<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Edit Task</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet" />

    <style>
        body {
            background: #f4f6f9;
            font-family: "Inter", sans-serif;
        }
        .topbar {
            background: #145da0;
            padding: 6px 24px;
            color: #fff;
            box-shadow: 0 2px 6px rgba(0,0,0,0.15);
        }
    </style>
</head>

<body>

<!-- Top Bar -->
<div class="topbar d-flex align-items-center">
    <img src="{{ asset('logo2.png') }}" style="margin-right:10px;" width="35" alt="">
    <h4 class="mb-0 fw-bold">Task Management System</h4>
</div>

<!-- Body -->
<div class="container py-5">
    <div class="card p-4 shadow-sm rounded-4">
        <h4 class="mb-4">Edit Task</h4>

        {{-- Validation Errors --}}
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('todos.update', $todo->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="row g-4">

                <!--  -->
                <div class="col-md-6">
                    <label class="form-label fw-semibold">Day</label>
                    <input type="date"
                           name="task_date"
                           class="form-control form-control-lg"
                           value="{{ old('task_date', $todo->task_date) }}"
                           required>
                </div>

                <!-- <div class="col-md-6">
                    <label class="form-label fw-semibold">Task Name</label>
                    <input type="text"
                           name="task_name"
                           class="form-control form-control-lg"
                           placeholder="Enter task name"
                           value="{{ old('task_name') }}"
                           required>
                </div> -->

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Project</label>
                    <select name="project_name" id="" class="form-select form-select-lg" required>
                        <option value="">Select Project</option>
                        <option value="Website Redesign" {{ old( 'project_name', $todo->project_name ) == 'Website Redesign' ? 'selected' : ''  }}>Website Redesign</option>
                        <option value="Mobile App Development" {{ old( 'project_name', $todo->project_name ) == 'Mobile App Development' ? 'selected' : ''  }}>Mobile App Development</option>
                        <option value="Marketing Campaign" {{ old( 'project_name', $todo->project_name ) == 'Marketing Campaign' ? 'selected' : ''  }}>Marketing Campaign</option>
                        <option value="Product Launch" {{ old( 'project_name', $todo->project_name ) == 'Product Launch' ? 'selected' : ''  }}>Product Launch</option>
                        <option value="Customer Onboarding" {{ old( 'project_name', $todo->project_name ) == 'Customer Onboarding' ? 'selected' : ''  }}>Customer Onboarding</option>
                    </select>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Module</label>
                    <select class="form-select form-select-lg" name="module" id="">
                         <option value="" >Select Task</option>
                        <option value="Development" {{ old('module', $todo->module) == 'Development' ? 'selected' : '' }}>Development</option>
                        <option value="Testing" {{ old('module', $todo->module) == 'Testing' ? 'selected' : '' }}>Testing</option>
                        <option value="Documentation" {{ old('module', $todo->module) == 'Documentation' ? 'selected' : '' }}>Documentation</option>
                        <option value="Code Review" {{ old('module', $todo->module) == 'Code Review' ? 'selected' : '' }}>Code Review</option>
                        <option value="Deployment" {{ old('module', $todo->module) == 'Deployment' ? 'selected' : '' }}>Deployment</option>
                    </select>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Task</label>
                    <select value="{{ old('task_name', $todo->task_name) }}" name="task_name" id="" class="form-select form-select-lg" required>
                        <option value="">Select Task</option>
                        <option value="Development" {{ old('task_name', $todo->task_name) == 'Development' ? 'selected' : '' }}>Development</option>
                        <option value="Testing" {{ old('task_name', $todo->task_name) == 'Testing' ? 'selected' : '' }}>Testing</option>
                        <option value="Documentation" {{ old('task_name', $todo->task_name) == 'Documentation' ? 'selected' : '' }}>Documentation</option>
                        <option value="Code Review" {{ old('task_name', $todo->task_name) == 'Code Review' ? 'selected' : '' }}>Code Review</option>
                        <option value="Deployment" {{ old('task_name', $todo->task_name) == 'Deployment' ? 'selected' : '' }}>Deployment</option>
                    </select>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Priority</label>
                    <input type="text"
                           name="priority"
                           class="form-control form-control-lg"
                           placeholder="Enter priority"
                           value="{{ old('priority', $todo->priority) }}"
                           required>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Due Date</label>
                    <input type="date"
                           name="deadline"
                           class="form-control form-control-lg"
                           value="{{ old('deadline', $todo->deadline) }}"
                           required>
                </div>
                <!--  -->

                <!-- <div class="col-md-6">
                    <label class="form-label fw-semibold">Task Name</label>
                    <input type="text"
                           name="task_name"
                           class="form-control form-control-lg"
                           value="{{ old('task_name', $todo->task_name) }}"
                           required>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Project Name</label>
                    <input type="text"
                           name="project_name"
                           class="form-control form-control-lg"
                           value="{{ old('project_name', $todo->project_name) }}"
                           required>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Module</label>
                    <input type="text"
                           name="module"
                           class="form-control form-control-lg"
                           value="{{ old('module', $todo->module) }}"
                           required>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Task Date</label>
                    <input type="date"
                           name="task_date"
                           class="form-control form-control-lg"
                           value="{{ old('task_date', $todo->task_date) }}"
                           required>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Deadline</label>
                    <input type="date"
                           name="deadline"
                           class="form-control form-control-lg"
                           value="{{ old('deadline', $todo->deadline) }}"
                           required>
                </div> -->

            </div>

            <div class="mt-4">
                <button type="submit" class="btn btn-primary btn-lg px-4">
                    <i class="bi bi-check-circle"></i> Update Task
                </button>

                <a href="{{ route('tasks.index') }}" class="btn btn-secondary btn-lg ms-2">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
