<?php

namespace App\Http\Controllers;

use App\Models\Todo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TodoController extends Controller
{
    /**
     * Display all tasks of logged-in user
     */
    // public function index()
    // {
    //     $tasks = Task::where('id', Auth::id())
    //         ->orderBy('task_date', 'desc')
    //         ->get();

    //     return view('tasks.index', compact('tasks'));
    // }

    public function index()
{
    $todos = Todo::select('id', 'task_name', 'project_name', 'module', 'task_date', 'deadline', 'priority')
        // ->where('id', Auth::id())
        ->orderBy('task_date', 'desc')
        ->get();
        // dd($todos);

    return view('todos.index', compact('todos'));
}


    /**
     * Show create task form
     */
    public function create()
    {
        return view('todos.create');
    }

    /**
     * Store new task
     */
    public function store(Request $request)
    {

        // dd($request->all());
        $request->validate([
            // 'task_name'    => 'required|string|max:255',
            'project_name' => 'required|string|max:255',
            'module'       => 'required|string|max:255',
            'task_date'    => 'required|date',
            'deadline'     => 'required|date|after_or_equal:task_date',
            'priority'     => 'required|string|max:255',
        ]);

        Todo::create([
            'id'      => Auth::id(),
            'task_name'    => $request->task_name,
            'project_name' => $request->project_name,
            'module'       => $request->module,
            'task_date'    => $request->task_date,
            'deadline'     => $request->deadline,
            'priority'     => $request->priority,
        ]);

        return redirect()
            ->route('todos.index')
            ->with('success', 'Todo created successfully');
    }

    /**
     * Show edit task form
     */
    
 
public function edit($id)
{
    $todo = Todo::select(
            'id',
            'task_name',
            'project_name',
            'module',
            'task_date',
            'deadline',
            'priority'
        )
        ->where('id', $id)
        // ->where('id', Auth::id()) // 🔐 security
        ->firstOrFail();               // ✅ single record

    return view('todos.edit', compact('todo'));
}



    /**
     * Update task
     */
    public function update(Request $request, Todo $todo)
    {
        // $this->authorizeTask($task);

        $request->validate([
            'task_name'    => 'required|string|max:255',
            'project_name' => 'required|string|max:255',
            'module'       => 'required|string|max:255',
            'task_date'    => 'required|date',
            'deadline'     => 'required|date|after_or_equal:task_date',
            'priority'     => 'required|string|max:255',
        ]);

        $todo->update([
            'task_name'    => $request->task_name,
            'project_name' => $request->project_name,
            'module'       => $request->module,
            'task_date'    => $request->task_date,
            'deadline'     => $request->deadline,
            'priority'     => $request->priority,
        ]);

        return redirect()
            ->route('todos.index')
            ->with('success', 'Todo updated successfully');
    }

    /**
     * Delete task
     */
    public function destroy(Todo $todo)
    {
        // $this->authorizeTask($task);
        $todo->delete();

        return redirect()
            ->route('todos.index')
            ->with('success', 'Todo deleted successfully');
    }

    /**
     * Ensure user owns the task
     */
    private function authorizeTask(Task $task)
    {
        if ($task->user_id !== Auth::id()) {
            abort(403, 'Unauthorized action');
        }
    }
}

