<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Add New Task</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet" />

    <style>
        body {
            background: #f4f6f9;
            font-family: "Inter", sans-serif;
        }
        .topbar {
            background: #145da0;
            padding: 6px 24px;
            color: #fff;
            box-shadow: 0 2px 6px rgba(0,0,0,0.15);
        }
    </style>
</head>

<body>

<!-- Top Bar -->
<div class="topbar d-flex align-items-center">
    <img src="<?php echo e(asset('logo2.png')); ?>" style="margin-right:10px;" width="35" alt="">
    <h4 class="mb-0 fw-bold">Task Management System</h4>
</div>

<!-- Body -->
<div class="container py-5">
    <div class="card p-4 shadow-sm rounded-4">
        <h4 class="mb-4">Add New Task</h4>

        
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('todos.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>

            <div class="row g-4">

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Day</label>
                    <input type="date"
                           name="task_date"
                           class="form-control form-control-lg"
                           value="<?php echo e(old('task_date')); ?>"
                           required>
                </div>

                <!-- <div class="col-md-6">
                    <label class="form-label fw-semibold">Task Name</label>
                    <input type="text"
                           name="task_name"
                           class="form-control form-control-lg"
                           placeholder="Enter task name"
                           value="<?php echo e(old('task_name')); ?>"
                           required>
                </div> -->

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Project</label>
                    <select name="project_name" id="" class="form-select form-select-lg" required>
                        <option value="">Select Project</option>
                        <option value="Website Redesign">Website Redesign</option>
                        <option value="Mobile App Development">Mobile App Development</option>
                        <option value="Marketing Campaign">Marketing Campaign</option>
                        <option value="Product Launch">Product Launch</option>
                        <option value="Customer Onboarding">Customer Onboarding</option>
                    </select>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Module</label>
                    <select class="form-select form-select-lg" name="module" id="">
                         <option value="">Select Task</option>
                        <option value="Development">Development</option>
                        <option value="Testing">Testing</option>
                        <option value="Documentation">Documentation</option>
                        <option value="Code Review">Code Review</option>
                        <option value="Deployment">Deployment</option>
                    </select>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Task</label>
                    <select name="task_name" id="" class="form-select form-select-lg" required>
                        <option value="">Select Task</option>
                        <option value="Development">Development</option>
                        <option value="Testing">Testing</option>
                        <option value="Documentation">Documentation</option>
                        <option value="Code Review">Code Review</option>
                        <option value="Deployment">Deployment</option>
                    </select>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Priority</label>
                    <input type="text"
                           name="priority"
                           class="form-control form-control-lg"
                           placeholder="Enter priority"
                           value="<?php echo e(old('priority')); ?>"
                           required>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Due Date</label>
                    <input type="date"
                           name="deadline"
                           class="form-control form-control-lg"
                           value="<?php echo e(old('deadline')); ?>"
                           required>
                </div>

            </div>

            <div class="mt-4">
                <button type="submit" class="btn btn-primary btn-lg px-4">
                    <i class="bi bi-check-circle"></i> Save Task
                </button>

                <a href="<?php echo e(route('tasks.index')); ?>" class="btn btn-secondary btn-lg ms-2">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\laravel\resources\views/todos/create.blade.php ENDPATH**/ ?>