<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Task Management System</title>

    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet" />

    <style>
        body {
            background: #f4f6f9;
            font-family: "Inter", sans-serif;
        }
        .topbar {
            background: #145da0;
            padding: 6px 24px;
            color: #fff;
            box-shadow: 0 2px 6px rgba(0,0,0,0.15);
        }
        .module-box {
            background: #fff;
            padding: 30px;
            border-radius: 16px;
            text-align: center;
            transition: all 0.25s ease;
            box-shadow: 0 4px 10px rgba(0,0,0,0.08);
            cursor: pointer;
        }
        .module-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 14px rgba(0,0,0,0.12);
        }
        .module-icon {
            font-size: 42px;
            color: #145da0;
            margin-bottom: 15px;
        }
        .module-title {
            font-size: 20px;
            font-weight: 600;
            color: #333;
        }
        .user-name {
            font-size: 14px;
            opacity: 0.9;
        }
    </style>
</head>
<body>

<!-- Top Bar -->
<div class="topbar d-flex align-items-center justify-content-between">
    <div class="d-flex align-items-center">
        <img src="{{ asset('logo2.png') }}" style="margin-right:10px;" width="35" alt="">
        <h4 class="mb-0 fw-bold">Task Management System</h4>
    </div>

    <div class="d-flex align-items-center gap-3">
        <span class="user-name">{{ Auth::user()->name }}</span>

        <!-- Logout -->
        <form method="POST" action="{{ route('logout') }}">
            @csrf
            <button class="btn btn-sm btn-light">Logout</button>
        </form>
    </div>
</div>

<!-- Modules -->
<div class="container py-5">
    <div class="row g-4">

        <div class="col-12 col-sm-6 col-lg-3">
            <a href="{{ route('todos.index') }}" class="text-decoration-none">
                <div class="module-box">
                    <div class="module-icon"><i class="bi bi-kanban"></i></div>
                    <div class="module-title">TODO</div>
                </div>
            </a>
        </div>

        <div class="col-12 col-sm-6 col-lg-3">
            <a href="{{ route('tasks.index') }}" class="text-decoration-none">
                <div class="module-box">
                    <div class="module-icon"><i class="bi bi-people"></i></div>
                    <div class="module-title">My Task</div>
                </div>
            </a>
        </div>

        <div class="col-12 col-sm-6 col-lg-3">
            <a href="#" class="text-decoration-none">
                <div class="module-box">
                    <div class="module-icon"><i class="bi bi-bar-chart"></i></div>
                    <div class="module-title">Delegated Task</div>
                </div>
            </a>
        </div>

        <div class="col-12 col-sm-6 col-lg-3">
            <a href="#" class="text-decoration-none">
                <div class="module-box">
                    <div class="module-icon"><i class="bi bi-gear"></i></div>
                    <div class="module-title">Settings</div>
                </div>
            </a>
        </div>

    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
