$(document).ready(function () {
    var headings = $('.fr-view h1, .fr-view h2, .fr-view h3, .fr-view h4, .fr-view .panel-title');
    var searchValue = $('#search').val()
    $('#search').focus().val('')
    $('#search').val(searchValue)
    if (headings && headings.length > 0) {
        $('#article-navigation-sidebar').show();
        headings.each(function (index, heading) {
            let headingText = heading.innerText.trim();
            if (headingText && headingText.length) {
                headingText = headingText.slice(0, 37);
                if (headingText.length === 37) {
                    headingText = headingText + '...';
                }
                $(heading).attr('id', `article-title-${index}`);
                $('#article-navigation-sidebar ul').append(
                    `<li><a class="smooth-scroll-link" href="#article-title-${index}">${headingText}</a></li>`
                );
            }
        });
    }
    $('.smooth-scroll-link').click(function (e) {
        e.preventDefault();
        $('html, body').animate(
            {
                scrollTop: $($.attr(this, 'href')).offset().top,
            },
            500
        );
    });
    $('.sidebar, #article-navigation-sidebar').theiaStickySidebar({
        additionalMarginTop: 30,
    });
    // To show master Article
    // $('.folder-list-title a').on('click', function (e) {
    //     e.preventDefault();
    // });
    $('.folder-list-title').click(function () {
        if ($(this).hasClass('active')) {
            $('.folder-list-title').removeClass('active open');
            $('+ .article-list', this).slideUp(300);
        } else {
            $('.folder-list-title').removeClass('active open');
            $('.article-list').slideUp(300);
            $(this).toggleClass('open active');
            $('+ .article-list', this).slideToggle(300);
        }
        
        // to counter the break in accordian-like animation
        const targetUrl = $(this).find('.folder-link').attr('href');
        event.preventDefault(); 
        setTimeout(function () {
            window.location.href = targetUrl;
        }, 400);

    });
    // hover event for mostread start
    $('.list-item').hover(
        function () {
            $(this).addClass('box');
            let $li = $(this);
            let $span = $li.find('span.material-symbols-outlined');
            $span.toggleClass('hidden');
        },
        function () {
            $(this).removeClass('box');
            let $li = $(this);
            let $span = $li.find('span.material-symbols-outlined');
            $span.toggleClass('hidden');
        }
    );
    // hover event for mostRead end
    scrollPer = false;
    $(window).on('scroll', function () {
        if ($('#article').length > 0) {
            a = $(window).scrollTop();
            b = $(window).height();
            c = $(document).height();
            p = (a / (c - b)) * 100;
            if (Math.floor(p) >= 70 && !scrollPer) {
                scrollPer = true;
                val = $('#articleId').val();
                $.ajax({
                    url: 'read',
                    method: 'post',
                    data: { id: val },
                    success: function (rsp) {},
                });
            }
        }
    });

    // focus on search box

    $('.more-topics').on('click',()=>{
        $('#myInput').focus()
    })

    // Folder Search box Theme3
    const folderDropdownOptions=$(".theme3.category_wrap .dropdown-menu li").toArray()
    $("#myInput").on("keyup",()=>{
        const filter = $("#myInput").val().toLowerCase();
        showDropdownOptions()
        if(filter.length){
            $('.dropdown-menu .dropdown-item').remove()
            folderDropdownOptions.forEach((el)=>{
                const elText=el.textContent.trim().toLowerCase();
                const isIncluded = elText.includes(filter);
                if (isIncluded) {
                    $('.dropdown-menu').append(el)
                }

            })
        }
    })
    const showDropdownOptions = () => {
        $('.dropdown-menu .dropdown-item').remove()
        folderDropdownOptions.forEach((el) => {
          el.style.display = 'flex';
          $('.dropdown-menu').append(el)
        })
      }

    // Key down logic

    $('.dropdown-menu').on('keydown',function(e){
        var itemLength=$(document).find('.dropdown-menu .dropdown-item').length
        const firstIndex = 1
        const lastIndex = itemLength
        var index = $('.dropdown-menu').find('.dropdown-item-hover').index();
        if(index===-1){
            index=0
        }
        switch(e.which){
            case 38:
              index = ((index == firstIndex || index == 0) ? lastIndex : index - 1);
              break;
            case 40:
              index = (index == lastIndex ? firstIndex : index + 1);
              break;
        }
        $(this).find('.dropdown-item-hover').removeClass('dropdown-item-hover');
        $(this).find('.dropdown-item:eq( '+ (index-1) +' )').addClass('dropdown-item-hover');
        $('.dropdown-menu')[0].scrollTop=$(this).find('.dropdown-item:eq( '+ (index-1) +' )')[0].offsetTop-250

        // on clicking enter

        if(e.which===13){
            $('.dropdown-item-hover').trigger('click')
         }
    })
 
    $('ul').on('scroll', function() {
        $('[data-bs-toggle="tooltip"]').tooltip('hide');
    });
});

function checkValidation(event) {
    var value = event.target.value.trim();
    if (event && event.key === 'Enter') {
        if (value.length < 1) {
            // event.preventDefault();
            // $('#search-form-error').html('Please type something to search...');
            // $('#search-form-error').fadeIn(300);
            // $('#search-form-error').addClass('show');
        } else {
            $('#search-form-error').fadeOut(0);
            $('#search-form-error').removeClass('show');
        }
    } else {
        $('#search-form-error').fadeOut(0);
        $('#search-form-error').removeClass('show');
    }
}

function clearSearchValue() {
    document.getElementById('search').value = null;
}

function openSideNav() {
    document.getElementById('sidebar').className += ' sidebar-active';
}

function closeSideNav() {
    document.getElementById('sidebar').classList.remove('sidebar-active');
}
