<?php 
if (! defined('BASEPATH')) 
{
	exit('No direct script access allowed');
}
class Store_data_fetch_model extends CI_Model
{
	public function fetch_store_name_asDropDown($location_type=0,$dept_type=0)
	{
		$this->db->select('*');
		$this->db->from('master_store');
		if($location_type!=0)
			$this->db->where('location_type', $location_type);
		//if($dept_type!=0)
			$this->db->where('department_type', $dept_type);		
		$query = $this->db->get();
		$options = array();
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['store_name'];
		}
		return $options;		
	}
	
    function fetch_search_items_list($search_type="")
	{		
		$this->db->select('*');
		$this->db->from('master_item');
		if($search_type!="")
		{
			$this->db->where('active_flag',$search_type);
		}
	
		$query = $this->db->get();
		//print_r($this->db->last_query());
		return $query->result();
	}
	function fetch_role_list()
	{
		$this->db->select('uid,misc_name');
		$this->db->from('master_misc');		
		$this->db->where('tag',101);
		$this->db->where('active_flag',1);
		$this->db->order_by('misc_name');
		$query = $this->db->get();
		return $query->result();
	}
function fetch_module_page_list($record_id)
	{
		$this->db->select('*');
		$this->db->from('rbac_master_module_page_new');
		$this->db->where('module_code',$record_id);
		$query = $this->db->get();
		//print_r($this->db->last_query());
		return $query->result();
	}
	public function fetch_employee_name_list($speciality_uid=-1,$employee_type=-1,$name_search_text="",$uid=0)
	{
		$this->db->select('*');
		$this->db->from('employee');
		if($name_search_text!="%")
		{
		if($speciality_uid>0)
			$this->db->where('speciality',$speciality_uid);
		if($employee_type>0)
			$this->db->where('employee_type',$employee_type);
		if($name_search_text!="")
			$this->db->like('full_name',$name_search_text,'both');		
		if($uid>0)
			$this->db->where('uid',$uid);
		}
		$query = $this->db->get();
		//print_r($this->db->last_query());
		return $query->result();

	}
	function fetch_employee_role_record($employee_uid)
	{
		$this->db->select('access.*,role.role_name,role.role_description');
	  $this->db->from('rbac_role_access_new access');
	  $this->db->join('rbac_role_master role', 'role.uid=access.role_uid');
      $this->db->where('access.active_flag',1);
      $this->db->where('access.user_uid',$employee_uid);
      $query = $this->db->get();
	  return $query->row();
	}
	function fetch_distinct_tag_name()
	{
		$this->db->select('DISTINCT(tag), tag_name');
		$this->db->from('master_misc');		
		
		//$this->db->where('active_flag',1);
		$this->db->order_by('tag');
		$query = $this->db->get();
		return $query->result();
	}
	function fetch_tag_name($tag)
	{
		$this->db->select('uid,misc_name,service_relationship_uid,tag');
		$this->db->from('master_misc');		
		$this->db->where('tag',$tag);
		$this->db->where('active_flag',1);
		$this->db->order_by('uid');
		$query = $this->db->get();
		return $query->result();
	}
	function fetch_misc_id($tag)
	{
		$this->db->select("max(uid) as max_id_no");
		$this->db->from('master_misc');
		$this->db->where('tag',$tag);
		$query = $this->db->get();
		return $query->row();	
	}
	function get_party_list()
	{
		$this->db->select("uid,party_name");
		$this->db->from('master_third_party');
		$this->db->where_not_in('party_category',array(1,2,3,4,5,6));//get all name except outsource and tpa
		$this->db->where('active_flag',1);
		$query = $this->db->get();
//echo $this->db->last_query();
		$options = array();
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['party_name'];
		}
		return $options;		
	
	}
	function fetch_service_rate_item($uid,$service_uid,$sponsor_uid,$clinic)
	{
		$this->db->select('*');
		$this->db->from('master_rate');
		$this->db->where('service_uid',$service_uid);		
		$this->db->where('item_uid',$uid);
		$this->db->where('sponsor_uid',$sponsor_uid);
		$this->db->where('clinic_uid',$clinic);
		$query = $this->db->get();
		return $query->row();
	}
	function fetch_doctor_rate_item($uid,$service_uid,$sponsor_uid,$appo_doctors,$clinic)
	{
		$this->db->select('*');
		$this->db->from('master_rate');
		$this->db->where('service_uid',$service_uid);		
		$this->db->where('item_uid',$uid);
		$this->db->where('sponsor_uid',$sponsor_uid);
		$this->db->where('doctor_uid',$appo_doctors);
		$this->db->where('clinic_uid',$clinic);
		$query = $this->db->get();
		return $query->row();
	}
	
	function fetch_search_third_party_list($search_type="")
	{
		$this->db->select('*');
		$this->db->from('master_third_party');
		
		if($search_type!="")
		{
			$this->db->where('party_category',$search_type);
		}
		$this->db->where('party_category!=',1);
		$this->db->order_by('party_category');
		$query = $this->db->get();
		//print_r($this->db->last_query());
		return $query->result();
	}
	function fetch_search_ward_list($search_type="")
	{
		$this->db->select('*');
		$this->db->from('master_ward');
		
		
		$this->db->where('clinic_uid',$_SESSION['hims_employee_sessionLogInfo']['clinicId']);
		$this->db->order_by('uid');
		$query = $this->db->get();
		//print_r($this->db->last_query());
		return $query->result();
	}
	function fetch_search_room_list($search_type="")
	{
		$this->db->select('*');
		$this->db->from('master_room');
		
		
		$this->db->where('clinic_uid',$_SESSION['hims_employee_sessionLogInfo']['clinicId']);
		$this->db->order_by('uid');
		$query = $this->db->get();
		//print_r($this->db->last_query());
		return $query->result();
	}
	function fetch_search_bed_list($search_type="")
	{
		$this->db->select('*');
		$this->db->from('master_bed');
		
		
		$this->db->where('clinic_uid',$_SESSION['hims_employee_sessionLogInfo']['clinicId']);
		$this->db->order_by('uid');
		$query = $this->db->get();
		//print_r($this->db->last_query());
		return $query->result();
	}
	function fetch_service_item_for_investigation($service_uid,$search_text)
	{
		if($service_uid==103)
			$cat=1;
		else if($service_uid==104)
			$cat=2;
		$this->db->select('*');
		$this->db->from('master_investigation');
		$this->db->where('category',$cat);
		if($search_text!="")
			$this->db->like('test_name',$search_text);
		$query = $this->db->get();
		return $query->result();		
	}
	function fetch_service_item($service_uid,$search_text)
	{
		$this->db->select('*');
		$this->db->from('item_services');
		$this->db->where('service_uid',$service_uid);
		if($search_text!="")
			$this->db->like('item_name',$search_text);
		//$this->db->where('clinic_uid',$_SESSION['hims_employee_sessionLogInfo']['clinicId']);
		$query = $this->db->get();
		return $query->result();	
	}
	public function fetch_employee_by_speciality($speciality_uid=-1,$employee_type=-1)
	{
		$this->db->select('*');
		$this->db->from('employee');
		if($speciality_uid!=-1)
			$this->db->where('speciality',$speciality_uid);
		if($employee_type!=-1)
			$this->db->where('employee_type',$employee_type);
		
		$query = $this->db->get();//print_r($this->db->last_query());die();
		$options = array();
		$options ["-1"] = "-- Select --";
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['full_name'];
		}
		return $options;	
	}
	function fetch_search_available_pincode_list($search_type="")
	{
		$this->db->select('*');
		$this->db->from('master_available_pincode');
		
		$this->db->order_by('uid');
		$query = $this->db->get();
		//print_r($this->db->last_query());
		return $query->result();
	}
	function fetch_group_list()
	{
		$this->db->select('*');
		$this->db->from('master_investigation');
		$this->db->where('service_uid',103);		
		$this->db->where('is_active',1);
		$this->db->where('is_group',1);
		
		$query = $this->db->get();
		return $query->result();
	}	
	function fetch_all_doctor_list($clinicId)
	{
	$this->db->select('*');
	$this->db->from('employee');
	$this->db->where('employee_type', 4);
	$this->db->where('active_flag', 1);
	$this->db->where("FIND_IN_SET($clinicId, clinic_location) !=", 0);
	$query = $this->db->get();
	return $query->result();

	}
	function fetch_search_stock_list()
	{
	$this->db->select('*');
	$this->db->from('inventory_purchase_details');
	$this->db->where('purchase_uid', 11);
	
	$query = $this->db->get();
	return $query->result();

	}
	function fetch_opening_stock_list($clinic_uid)
	{
	$this->db->select('t1.item_name,t1.uid');
	$this->db->from('master_item t1');
	//$this->db->join('inventory_purchase_details t2', 't2.item_uid=t1.uid','LEFT');
	//$this->db->where('t2.clinic_uid', $clinic_uid);
	//$this->db->where('t2.purchase_uid', 11);
	
	$query = $this->db->get();
	return $query->result();
	}
	function fetch_opening_stock($item_uid,$batch_no="",$location="")
	{
		$this->db->select_sum('quantity');
		$this->db->from('inventory_purchase_details');
		$this->db->where('purchase_uid',11);
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}
		if($location!="")
		{
			$this->db->where('store_uid',$location);
		}		
		$this->db->where('item_uid',$item_uid);
		$query = $this->db->get();
		return $query->row();//passing all result to controller			
	}
	function fetch_item_total_entry($item_uid,$batch_no="",$location="")
	{
		$this->db->select('sum(quantity) as tot_qty');
		$this->db->from('inventory_purchase_details');
		$this->db->where('purchase_uid!=',11);
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}
		if($location!="")
		{
			$this->db->where('store_uid',$location);
		}		
		$this->db->where('item_uid',$item_uid);
		$query = $this->db->get();
		return $query->row();//passing all result to controller			
	}
	function fetch_free_item_total_entry($item_uid,$batch_no="",$location="")
	{
		$this->db->select('sum(free_quantity) as tot_freeqty');
		$this->db->from('inventory_purchase_details');
		$this->db->where('purchase_uid!=',11);
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}
		if($location!="")
		{
			$this->db->where('store_uid',$location);
		}		
		$this->db->where('item_uid',$item_uid);
		$query = $this->db->get();
		return $query->row();//passing all result to controller			
	}
	function fetch_item_total_issue($item_uid,$batch_no="",$location="")
	{
		$this->db->select('sum(quantity) as tot_issue_qty');
		$this->db->from('inventory_stock_issue_details');
		$this->db->where('item_uid',$item_uid);
		$this->db->where('is_transfer',0);
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}
		if($location!="")
		{
			$this->db->where('location_uid_from',$location);
		}		
		$query = $this->db->get();
		//print_r($this->db->last_query());
		//die(0);
		return $query->row();//passing all result to controller			
	}
	function fetch_item_total_purchase_return($item_uid,$batch_no="",$location="")
	{
		$this->db->select('sum(return_quantity) as tot_return_qty');
		$this->db->from('inventory_pr_sorting');
		$this->db->where('item_uid',$item_uid);
		$this->db->where('status',1);
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}
		//if($location!="")
		//{
		//	$this->db->where('location_uid_from',$location);
		//}		
		$query = $this->db->get();
		//print_r($this->db->last_query());
		//die(0);
		return $query->row();//passing all result to controller			
	}
	
	public function fetch_indent_order_list($to_date,$from_date,$location_uid="-1",$indent_no)
	{
		$this->db->select('*');
		$this->db->from('inventory_indent');
		if($indent_no!="")
		{
			$this->db->where('uid', $indent_no);
		}
		else
		{
		$this->db->where('indent_date>=', $from_date); 
		$this->db->where('indent_date<=', $to_date);
		}
		if($location_uid!=-1)
			$this->db->where('location_uid_to', $location_uid);
		$this->db->where('status',1);	

		$query = $this->db->get();
		return $query->result();		
	}
	public function fetch_store_name($pharmacy_uid)
	{
		$qry="SELECT * FROM `master_store` WHERE `uid` = '$pharmacy_uid'    ";
		
		$query=$this->db->query($qry);
		return $query->result();
	}
	public function fetch_indent_details_list($indent_uid)
	{
		
		$this->db->select('ind.*,itm.item_name,i.indent_date');
		$this->db->from('inventory_indent_details ind');
		$this->db->join('inventory_indent i','ind.indent_uid=i.uid');
		//$this->db->join('master_store sm', 'sm.uid=ind.location_uid_to');
		$this->db->join('master_item itm','itm.uid=ind.item_uid');
		
			$this->db->where('ind.indent_uid',$indent_uid);
			
		$query = $this->db->get();
		return $query->result();//passing all result to controller		
		
	}
	public function fetch_indent_details($indent_id,$clinicId)
	{
			//$qry="SELECT id.*,sm.uid as store_id,sm.clinic_code as store_name,pur.item_uid,pur.batch_no,pur.expiry_date,pur.hsn,pur.tax_rate,pur.mrp,pur.pack FROM inventory_indent_details id,master_clinic sm,inventory_purchase_details pur WHERE pur.store_uid=$clinicId and id.item_uid=pur.item_uid and `indent_uid` = '$indent_id' order by pur.item_uid  , `pur`.`expiry_date` ASC";
			$qry="SELECT ind.*,pur.store_uid,pur.item_uid,pur.batch_no,pur.expiry_date,pur.hsn,pur.tax_rate,pur.mrp,pur.pack FROM inventory_indent_details ind,inventory_purchase_details pur WHERE ind.indent_uid=$indent_id AND pur.store_uid=$clinicId AND ind.item_uid=pur.item_uid order by pur.item_uid , `pur`.`expiry_date` ASC; ";
		$query=$this->db->query($qry);
		return $query->result();
	}
	public function fetch_item_name($item_uid)
	{
		
			$qry="SELECT * FROM `master_item` WHERE `uid` = '$item_uid' ";
		
		$query=$this->db->query($qry);
		return $query->row();
	}
	public function fetch_unit_name($indent_unit_uid)
	{
		$qry="SELECT * FROM `master_misc` WHERE `uid` = '$indent_unit_uid' ";
		
		$query=$this->db->query($qry);
		return $query->result();
	}
	function check_issue_stock($indent_uid="",$item_uid)
	{
		$this->db->select('sum(quantity) as tot_issue_qty');
		$this->db->from('inventory_stock_issue_details');
		$this->db->where('item_uid',$item_uid);
			
		if($indent_uid!="")
		{
			$this->db->where('indent_uid',$indent_uid);
		}
		$query = $this->db->get();
		return $query->row();//passing all result to controller			
	}
	public function fetch_item_details($item_id)
	{
		$qry="SELECT * FROM `inventory_purchase_details` WHERE `item_uid` = '$item_id'   ";		
		$query=$this->db->query($qry);
		return $query->result();
	}
	function fetch_item_total_issue_qty($indent_uid="",$item_uid,$batch_no="",$location="")
	{
		$this->db->select('sum(quantity) as tot_issue_qty');
		$this->db->from('inventory_stock_issue_details');
		$this->db->where('item_uid',$item_uid);
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}
		if($location!="")
		{
			$this->db->where('location_uid_from',$location);
		}	
		if($indent_uid!="")
		{
			$this->db->where('indent_uid',$indent_uid);
		}
		$query = $this->db->get();
		return $query->row();//passing all result to controller			
	}
	function fetch_item_total_issueReceived($item_uid,$batch_no="",$location_uid="")
	{
		$this->db->select('sum(quantity) as tot_qty');
		$this->db->from('inventory_stock_issue_details');
		$this->db->where('is_goodsReceived','1');
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}
		if($location_uid!="")
		{
			$this->db->where('location_uid_to',$location_uid);
		}		
		$this->db->where('item_uid',$item_uid);
		$query = $this->db->get();
		return $query->row();//passing all result to controller			
	}
	function fetch_item_total_sale($item_uid,$batch_no="",$location="",$clinic_uid)
	{
		$this->db->select('sum(quantity) as tot_sale_qty');
		$this->db->from('billing');
		$this->db->where('item_id',$item_uid);
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}
		if($location!="")
		{
			$this->db->where('clinic_uid',$location);
		}
		$this->db->where('sale_category', 1);		
		$this->db->where('cancel_flag', 0);		
		$query = $this->db->get();
		//print_r($this->db->last_query());
		//die(0);
		return $query->row();//passing all result to controller			
	}
	public function fetch_sales_return_item_quantity($item_id,$batch_no="",$location_uid="",$clinic_uid)
	{  
		$this->db->select('sum(quantity) as total_return_sales_quantity');
		$this->db->from('inventory_stock_issue_details');
		$this->db->where('item_uid',$item_id);
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}
		if($location_uid!="")
		{
			$this->db->where('location_uid_to',$location_uid);
		}
		$this->db->where('stock_category', 2);	
		$query = $this->db->get();
		//print_r($this->db->last_query());
		//die(0);
		return $query->row();		
	}
	public function fetch_stock_transfer_item_quantity($item_id,$batch_no="",$location_uid="",$clinic_uid)
	{  
		$this->db->select('sum(quantity) as total_stock_transfer_quantity');
		$this->db->from('inventory_stock_issue_details');
		$this->db->where('item_uid',$item_id);
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}
		if($location_uid!="")
		{
			$this->db->where('location_uid_from',$location_uid);
		}
		$this->db->where('is_goodsReceived', 1);	
		$this->db->where('is_transfer', 1);	
		$query = $this->db->get();
		//print_r($this->db->last_query());
		//die(0);
		return $query->row();		
	}
	function fetch_closing_stock_list()
	{
	$this->db->select('*');
	$this->db->from('master_item t1');
	
	
	$query = $this->db->get();
	return $query->result();
	}
	function fetch_approved_indent_list($date,$date_to="",$location="")
	{
		$this->db->select('si.*,sm.store_name,cn.clinic_code as store_name');
		$this->db->from('inventory_stock_issue si');
		$this->db->join('master_store sm', 'sm.uid=si.location_uid_from', 'LEFT');		
		$this->db->join('master_clinic cn', 'cn.uid=si.location_uid_from', 'LEFT');		
		if($date_to=="")
			$this->db->where('doi',$date);
		else
		{
			$this->db->where('doi>=',$date);
			$this->db->where('doi<=',$date_to);
		}
		//$this->db->where('location_uid_from',$location);
		//$this->db->where('is_transfer','0');
		$this->db->where('location_uid_to',$location);
		$query = $this->db->get();
		//print_r($this->db->last_query());
		return $query->result();//passing all result to controller			
	}
	public function fetch_medicine_record($medicine_id)
	{ 
		$this->db->select('*');
		$this->db->from('master_item');
		$this->db->where('uid', $medicine_id);
		$query=$this->db->get();
		return $query->row();		
	}
	
	
}