<?php 
if (! defined('BASEPATH')) 
{
	exit('No direct script access allowed');
}
class Sales_data_fetch_model extends CI_Model
{
	public function fetch_item_by_name($item_name,$item_category)
	{
		$this->db->select('im.uid,im.item_name,im.hsn,im.category');
		$this->db->from('master_item im');
		$this->db->where('im.category',$item_category);
		if($item_name!='%')
		{
		$this->db->like('im.item_name', $item_name); 
		}
		$this->db->order_by('im.item_name');
		$query = $this->db->get();
		//print_r($this->db->last_query());
		return $query->result();		
	}
	function fetch_item_total_issueReceived($item_uid,$batch_no="",$location_uid="")
	{
		$this->db->select('sum(quantity) as tot_qty');
		$this->db->from('inventory_purchase_details');
		//$this->db->where('is_goodsReceived','1');
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}
		if($location_uid!="")
		{
			$this->db->where('store_uid',$location_uid);
		}		
		$this->db->where('item_uid',$item_uid);
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->row();//passing all result to controller			
	}
	function fetch_item_total_issue($item_uid,$batch_no="",$location="")
	{
		$this->db->select('sum(quantity) as tot_issue_qty');
		$this->db->from('inventory_purchase_details');
		$this->db->where('item_uid',$item_uid);
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}		
		$query = $this->db->get();
		return $query->row();//passing all result to controller			
	}
	function fetch_item_total_sale($item_uid,$batch_no="",$location="",$clinic_uid)
	{
		$this->db->select('sum(quantity) as total_sales_quantity');
		$this->db->from('inventory_pahmacy_sale_details');
		$this->db->where('item_uid',$item_uid);
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}
		if($location!="")
		{
			$this->db->where('pharmacy_uid',$location);
		}
		$this->db->where('sale_category', 1);		
		$this->db->where('clinic_uid', $clinic_uid);		
		$query = $this->db->get();
		//print_r($this->db->last_query());
		//die(0);
		return $query->row();//passing all result to controller			
	}
	public function fetch_sales_return_item_quantity($item_id,$batch_no,$location_uid,$clinic_uid)
	{  
		$this->db->select('sum(quantity) as total_return_sales_quantity');
		$this->db->from('inventory_pahmacy_sale_details');
		$this->db->where('item_uid', $item_id);
		if($batch_no!="")
		{
		$this->db->where('batch_no', $batch_no);
		}
		$this->db->where('sale_category', 2);
		$this->db->where('pharmacy_uid', $location_uid);		
		$this->db->where('clinic_uid', $clinic_uid);		
		$query=$this->db->get();
		return $query->row();		
	}
	public function fetch_indent_order_list($to_date,$from_date,$indent_type,$location_from_uid,$indent_no,$indent_status)
	{
		$this->db->select('ind.*');
		$this->db->from('inventory_indent ind');
		//$this->db->join('master_store sm', 'sm.uid=ind.location_uid_to');
		if($indent_no!="")
		{
			$this->db->where('ind.uid', $indent_no);
		}
		else
		{
		$this->db->where('ind.indent_date>=', $from_date); 
		$this->db->where('ind.indent_date<=', $to_date);
		}
		
		$this->db->where('ind.location_uid_from',$location_from_uid);
		//$this->db->where('ind.location_uid_to',$store_uid);
		$this->db->where('ind.status',$indent_status);	
//print_r($this->db->last_query()); die(0);
		$query = $this->db->get();
		return $query->result();		
	}
	public function fetch_indent_details_list($indent_uid)
	{
		
		$this->db->select('ind.*,i.status,itm.item_name,itm.hsn, i.indent_date, sm.store_name');
		$this->db->from('inventory_indent_details ind');
		$this->db->join('inventory_indent i','ind.indent_uid=i.uid');
		$this->db->join('master_store sm', 'sm.uid=ind.location_uid_to');
		$this->db->join('master_item itm','itm.uid=ind.item_uid');
		
			$this->db->where('ind.indent_uid',$indent_uid);
			
		$query = $this->db->get();
		//echo $this->db->last_query();
		return $query->result();//passing all result to controller		
		
	}
	public function fetch_store_name($store_uid)
	{
		$this->db->select('*');
		$this->db->from('master_store');		
		$this->db->where('uid',$store_uid);		
		$query=$this->db->get();
		return $query->row();
	}
	function fetch_approved_indent_list($date,$date_to="",$location="")
	{
		$this->db->select('si.*,sm.store_name,cn.clinic_code as store_name');
		$this->db->from('inventory_stock_issue si');
		$this->db->join('master_store sm', 'sm.uid=si.location_uid_from', 'LEFT');		
		$this->db->join('master_clinic cn', 'cn.uid=si.location_uid_from', 'LEFT');		
		if($date_to=="")
			$this->db->where('doi',$date);
		else
		{
			$this->db->where('doi>=',$date);
			$this->db->where('doi<=',$date_to);
		}
		//$this->db->where('location_uid_from',$location);
		//$this->db->where('is_transfer','0');
		$this->db->where('location_uid_to',$location);
		$query = $this->db->get();
		//print_r($this->db->last_query());
		return $query->result();//passing all result to controller			
	}
	function fetch_indent_issue_list($issue_id)
	{
		$this->db->select('si.*,sm.store_name,cn.clinic_code as store_name');
		$this->db->from('inventory_stock_issue_details si');
		$this->db->join('master_store sm', 'sm.uid=si.location_uid_from', 'LEFT');		
		$this->db->join('master_clinic cn', 'cn.uid=si.location_uid_from', 'LEFT');	
		
		$this->db->where('si.issue_uid',$issue_id);
		
		$query = $this->db->get();
		return $query->result();//passing all result to controller			
	}
	public function fetch_medicine_record($medicine_id)
	{ 
		$this->db->select('*');
		$this->db->from('master_item');
		$this->db->where('uid', $medicine_id);
		$query=$this->db->get();
		return $query->row();		
	}
	public function fetch_items_dd()
	{
		$this->db->select('*');
		$this->db->from('master_item');
		$query = $this->db->get();
		$options = array();
		$options ["-1"] = "-- Select --";
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['item_name']."   [ Rs ".$row['mrp']." ]";
		}
		return $options;	
	}
	public function fetch_all_doctors_name_dd()
	{
		$this->db->select('*');
		$this->db->from('employee');
		$this->db->where('employee_type',4);
		$query = $this->db->get();
		$options = array();
		$options ["-1"] = "-- Select --";
		foreach($query->result_array() as $row)
		{
		   $options [$row['full_name']] = $row['full_name'];
		}
		return $options;	
	}
	function fetch_last_invoice_no($clinic_uid)
	{
		$this->db->select("max(invoice_no) as last_invoice_no");
		$this->db->from('billing_master');
		$this->db->where('clinic_uid',$clinic_uid);
		$query = $this->db->get();
		return $query->row();	
	}
	function fetch_last_receipt_no($clinic_uid)
	{
		$this->db->select("max(receipt_no) as last_receipt_no");
		$this->db->from('bill_receipt');
		$this->db->where('clinic_uid',$clinic_uid);
		$query = $this->db->get();
		return $query->row();	
	}
	public function fetch_clinic_by_id($clinic_uid)
	{
		$this->db->select('*');
		$this->db->from('master_clinic');
		$this->db->where('uid',$clinic_uid);
		$query = $this->db->get();
		return $query->row();	
	}
	public function fetch_bill_master_details($bill_no)
	{
		$this->db->select("bm.uid,bm.entry_date_time,bill_date,bill_section,bm.sponsor_uid,patient_uid,treating_doctor,printAsDiet,full_name as 'patient_full_name',gender,age,dob,mobile,address1,address2,city,pin,gross_amount,discount_amount,net_amount,cancel_flag,bm.entry_by,bm.advance_receipt_id,bm.advance_amount,bm.invoice_no,bm.bill_prefix,bm.token_no");		
		$this->db->from('billing_master bm');
		$this->db->where('bm.uid',$bill_no);
		$query = $this->db->get();
		return $query->row();		
	}
	public function fetch_patient_invoice_details($bill_no)
	{	
		$this->db->select("billmast_uid,bill_no,service_uid,item_id,mi.item_name,service_amount,discount_amount,gross_amount,bill_date,b.entry_date_time,cancel_flag");
		$this->db->from('billing b');		
		$this->db->join('master_item mi', 'mi.uid=b.item_id');		
		$this->db->where('billmast_uid',$bill_no);
		$query = $this->db->get();
		return $query->result();		
	}
	function fetch_bill_date_time($bill_no)
	{
		$this->db->select('entry_date_time');
		$this->db->from('billing_master');
		$this->db->where('uid',$bill_no);
		$query = $this->db->get();
		return $query->row();	
	}
	function fetch_employee_record($employee_uid)
	{
		$this->db->select('*');
		$this->db->from('employee');	
		$this->db->where('uid',$employee_uid);	
		$query = $this->db->get();
		return $query->row();	
	}
	public function fetch_patient_payment_details($bill_no)
	{
		$this->db->select("receipt_prefix,uid,voucher_date,net_amount,cash_mode,card_mode,cheque_mode,bank_transfer_mode,advance_mode,upi_wallet_mode,receipt_no,source");
		$this->db->from('bill_receipt');
		$this->db->where('billmast_uid',$bill_no);
		$this->db->where_in('source',array(0,1));
		$query = $this->db->get();
		return $query->result();		
	}
	public function fetch_patient_billing_master_details($bill_no)
	{
		$this->db->select("bm.uid, `bill_prefix`, `bill_date`, `patient_uid`, `gross_amount`, `discount_amount`, `net_amount`, `discount_reason`, `discount_approved_by`, `bill_section`, `treating_doctor`, bm.clinic_uid, bm.entry_by, bm.entry_date_time");
		$this->db->from('`billing_master bm');		
		$this->db->join('employee e', 'bm.entry_by=e.uid');		
		$this->db->where('bm.uid',$bill_no);
		$query = $this->db->get();
		return $query->row();		
	}
	function fetch_bill_list($search_parameter)	
	{
		$this->db->select("bm.uid, `bill_prefix`,`invoice_no`, `bill_date`, `bm`.`bill_section`,`bm`.`patient_uid`, `gross_amount`, `discount_amount`, `bm`.`net_amount`,bm.cancel_flag,full_name,mobile,gender");
		$this->db->from('`billing_master bm');		
		$this->db->where('bm.clinic_uid',$_SESSION['pab_sessionLogInfo']['clinicId']);
		$this->db->where('bm.bill_date>=',$search_parameter['from_date']);
		$this->db->where('bm.bill_date<=',$search_parameter['to_date']);
		if($search_parameter['patient_uid']>0)
			$this->db->where('bm.patient_uid',$search_parameter['patient_uid']);
		if($search_parameter['patient_name']!="")
			$this->db->like('bm.full_name',$search_parameter['patient_name']);
		if($search_parameter['bill_receipt_no']!="")
		{
			$invoice_receipt_no_prefix=substr($search_parameter['bill_receipt_no'], 0, strpos($search_parameter['bill_receipt_no'], '/'));
			$invoice_receipt_no_postfix=(int)(substr($search_parameter['bill_receipt_no'],strpos($search_parameter['bill_receipt_no'], '/')+1));
			$rcptString=substr($invoice_receipt_no_prefix,-4);
			$invoice_receipt_no_prefix=$invoice_receipt_no_prefix."/";
			if($rcptString=='OPRC')
			{
				$this->db->where('bm.uid=(select billmast_uid from bill_receipt where CONCAT(receipt_prefix,receipt_no)=\''.$invoice_receipt_no_prefix.$invoice_receipt_no_postfix.'\')' ,NULL, FALSE);
			}
			else
				$this->db->where('CONCAT(bm.bill_prefix,bm.invoice_no)',$invoice_receipt_no_prefix.$invoice_receipt_no_postfix);
		}			
		$query = $this->db->get();
		$result= $query->result();	
		return $result;
	}
	function fetch_closing_stock_list()
	{
	$this->db->select('t1.item_name,t1.uid');
	$this->db->from('master_item t1');
	
	
	$query = $this->db->get();
	return $query->result();
	}
	function fetch_scroll_list($search_parameter)
	{
		$this->db->select('voucher_date,sum(net_amount) as sum_net,sum(cash_mode) as total_cash,sum(card_mode) as total_card,sum(cheque_mode) as total_cheque,sum(bank_transfer_mode) as total_bank_transfer,sum(advance_mode) as total_advance,sum(upi_wallet_mode) as total_upi_wallet');
		$this->db->from('bill_receipt');
		$this->db->where('entry_by',$_SESSION['pab_sessionLogInfo']['loggedUserId']);
		$this->db->where('clinic_uid',$_SESSION['pab_sessionLogInfo']['clinicId']);
		$this->db->where('cancel_flag','0');
		$this->db->where('voucher_date >=',date('Y-m-d',strtotime($search_parameter['from_date'])));
		$this->db->where('voucher_date <=',date('Y-m-d',strtotime($search_parameter['to_date'])));
		$this->db->group_by('voucher_date');
		$query = $this->db->get();
		return $query->result();		
	}
	function fetch_service_cancel_refund_total_amount($from_date,$to_date,$employee)
	{
		$this->db->select('sum(net_amount) as serviceCancelledTotalAmount');
		$this->db->from('bill_refund');
		$this->db->where('entry_by',$employee);
		$this->db->where('clinic_uid',$_SESSION['pab_sessionLogInfo']['clinicId']);
		//$this->db->where('refund_for','2');//partial refund only
		$this->db->where('refund_date >=',date('Y-m-d',strtotime($from_date)));	
		$this->db->where('refund_date <=',date('Y-m-d',strtotime($to_date)));	

		$query = $this->db->get();
		return $query->row();	
	}
	function fetch_stock_transfer_list($search_parameter)	
	{
		$this->db->select("*");
		$this->db->from('inventory_stock_issue_details');		
		$this->db->where('location_uid_from',$_SESSION['pab_sessionLogInfo']['clinicId']);
		$this->db->where('doi>=',$search_parameter['from_date']);
		$this->db->where('doi<=',$search_parameter['to_date']);
					
		$query = $this->db->get();
		$result= $query->result();	
		return $result;
	}
}