<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	
	class Sales extends MX_Controller 
	{
		
		public function __construct()
		{
			parent::__construct();
			if($_SESSION['pab_sessionLogInfo']['userLoggedin']!=true)
			{
				redirect(base_url());
			}	
			
			$this->load->helper('utility');
			$this->load->model('Sales_data_fetch_model'); 
			$this->load->model('Common/Common_data_add_model');
			$this->load->model('Common/Common_data_fetch_model');
			
			
		}
		
		public function dashboard()
		{
			$data = array();
			$data['module']=$this->Common_data_fetch_model->fetch_all_modules($service_relationship_uid=0);
			$this->template->load('layout_sales', 'dashboard', $data);
			
		}
	public function indent($uid = '', $action = '')
		{
			$data = array();
			$data['module']=$this->Common_data_fetch_model->fetch_all_modules($service_relationship_uid=0);
			if ($uid === 'new') {
		   $data['uid'] = '0';
		   $data['clinicName']=$this->Common_data_fetch_model->fetch_clinic();
		   $data['storeName']=$this->Common_data_fetch_model->fetch_store($location_type=10200001,$department_type=0);
		   $this->template->load('layout_sales', 'indent_add', $data);
			}
			else
			{
			$this->template->load('layout_sales', 'indent_list', $data);
			}
			
		}
		function search_item_by_name()
		{
		$item_name=$this->input->post('search_text');
		$list_id=$this->input->post('list_id');
		$field_id=$this->input->post('field_id');
		$row_id=$this->input->post('row_id');
		$item_type=$this->input->post('item_category');
		if($item_type!="")
		{
			$item_category=$this->input->post('item_category');
		}
		else{
			$item_category=1;
		}
		$data=$this->Sales_data_fetch_model->fetch_item_by_name($item_name,$item_category);		
		foreach($data as $record)
		{
		?>
			<li><a class="dropdown-item" href="javascript:void(0)" onclick="item_set_record('<?=base64_encode($record->uid)?>','<?=$record->item_name?>','<?=$list_id?>','<?=$field_id?>','<?=$row_id?>','<?=$record->hsn?>','<?=$item_category?>')"><?=$record->item_name?></a></li>			
		<?php
			
		}//end of foreach
				
		}
		function get_main_store_stock($return_flag=0)
		{
		$item_uid=base64_decode($this->input->post('enc_item_id'));
		$location_uid=$this->input->post('location_uid');			
		$this->load->library('CustomInventoryLib');
		$myLib = new CustomInventoryLib();
		//get counter stock
		$StoreStock=$myLib->getStoreStock($item_uid,$batch_no="",$location_uid,$return_flag=0);
		echo $StoreStock;
		}
		function get_counter_stock($return_stat='0',$itemUid=0,$location_uid=0)
	{
		if($itemUid==0 && ($this->input->post('enc_item_id')))
			$item_uid=base64_decode($this->input->post('enc_item_id'));		
		else
			$item_uid=$itemUid;
		if($location_uid==0 && ($this->input->post('location_uid')))
			$location_uid=$this->input->post('location_uid');	
		else
			$location_uid=$location_uid;
		$this->load->library('CustomInventoryLib');
		$myLib = new CustomInventoryLib();
		//get counter stock
		$currentCounterStock=$myLib->getLocationStock($item_uid,$return_flag=1,$batch_no="",$location_uid,$location_type=1);//return required			
//$totalSale=$this->Sales_data_fetch_model->fetch_item_total_sale($item_uid);
		if($return_stat=="0")
		{
			echo $currentCounterStock ;
		}
		else
		{
			return $currentCounterStock ;
		}
	}
	
	function saveIndent()
	{
		$uid=$this->input->post('uid'); 
	    if($uid=="0")//save
		{
		   	$no_indent_row=count($this->input->post('item_uid'));
			
			$item_uid_array=$this->input->post('item_uid');
			$indent_quantity_array=$this->input->post('quantity');
			$indent_unit_uid_array=$this->input->post('unit_uid');
			$indent_item_category_array=$this->input->post('item_category');
			//$item_type_array=$this->input->post('item_type');
            $indentData=array(
				"clinic_uid"=>$_SESSION['pab_sessionLogInfo']['clinicId'],
				"location_uid_to"=>$this->input->post('store_uid'),
				"location_uid_from"=>$_SESSION['pab_sessionLogInfo']['clinicId'],
				"indent_date"=>date("Y-m-d"),
				"created_by"=>$_SESSION['pab_sessionLogInfo']['loggedUserId'],
				"entry_by"=>$_SESSION['pab_sessionLogInfo']['loggedUserId'],
				"entry_date_time"=>date("Y-m-d H:i:s")			
			);
			$this->Common_data_add_model->save_data($indentData,'inventory_indent');
			$indent_uid=$this->db->insert_id();
			
			for($i=0;$i<$no_indent_row;$i++)
			{
				$indentDetailsData=array(
					"indent_uid"=>$indent_uid,
					"item_uid"=>$item_uid_array[$i],
					"indent_quantity"=>$indent_quantity_array[$i],
					"item_type"=>1,
					"item_category"=>$indent_item_category_array[$i],
					"location_uid_from"=>$_SESSION['pab_sessionLogInfo']['clinicId'],
					"location_uid_to"=>$this->input->post('store_uid'),
					"clinic_uid"=>$_SESSION['pab_sessionLogInfo']['clinicId']
				);			
				$this->Common_data_add_model->save_data($indentDetailsData,'inventory_indent_details');
			}
			$this->session->set_flashdata('success', 'Data Saved...');
			redirect(base_url()."sales/indentApproved");
		}
	}
	
	function get_indent_order_details_list()
	{
		
		$to_date=date('Y-m-d',strtotime($this->input->post('to_date')));
		$from_date=date('Y-m-d',strtotime($this->input->post('from_date')));
		$location_from_uid=$_SESSION['pab_sessionLogInfo']['clinicId'];
		//$store_uid=$this->input->post('store_uid');
		$indent_type='1';
		$indent_no="";
		$indent_status=0;
		$data=$this->Sales_data_fetch_model->fetch_indent_order_list($to_date,$from_date,$indent_type,$location_from_uid,$indent_no,$indent_status);
		$k=0;
		$oldIndent=0;
		$newIndent=0;
		$noOfIndent=0;
		$color=2;		
		foreach($data as $record)
		{
		    
			$k++;
			//$response1=$this->Sales_data_fetch_model->fetch_store_name($record->location_uid_to);
		
			
			switch($record->status)
			{
				case 0:
					$statusTxt="Create";
					break;
				case 1:
					$statusTxt="Completed";
					break;
				case 2:
					$statusTxt="Reject";
					break;					
									
			}
			  
			
				
			
					?>
				<tr>
  <td><?php echo $k;?></td>
  <td  ><a  data-bs-toggle="collapse" data-bs-target="#demo<?php echo $k;?>" class="accordion-toggle cursor-pointer" style="cursor: pointer;height: auto;
  margin-left: 5px;"><?php echo $record->uid;?></a> <!--<a  class="btn custom_button" onclick="popup_print(<?php echo $record->uid;?>)"><i class="fa fa-print" aria-hidden="true"></i></a>--></td>
  <td><?php echo get_clinic_code($record->location_uid_to); ?></td>
  <td><?php echo $record->indent_date;?></td>
  <td><?php if($record->priority==1){?>
    Low
    <?php }if($record->priority==2){?>
    Medium
    <?php }if($record->priority==3){?>
    High
    <?php }?></td>
  <td><?php echo $record->remarks;?></td>
  <td><?=ucwords(get_employee_name($record->created_by))?></td>
  
</tr>
<tr>
  <td  colspan="8" class="hiddenRow"><div class="accordian-body collapse blue_box" id="demo<?php echo $k;?>" style="background-color: rgb(133, 218, 228);">
      <table class="table table-hover  table-condensed hidden_table" >
        <tr class="">
            <td>Item</td>
            <td>Quantity</td>
			<td>Status</td>
          </tr>
        <tbody>
		<?php
		$indent_uid=$record->uid;
		$data=$this->Sales_data_fetch_model->fetch_indent_details_list($indent_uid);
		
		foreach($data as $record)
		{
			switch($record->status)
			{
				case 0:
					$statusTxt="Pending";
					break;
				case 1:
					$statusTxt="Processing";
					break;
				case 2:
					$statusTxt="Completed";
					break;					
									
			}
		?>
		
          <tr>
            <td><?php echo $record->item_name;?></td>
            <td><?php echo $record->indent_quantity;?></td>
           <td><?=$statusTxt;?></td>
          </tr>
		  <?php 
		}
		  ?>
          
        </tbody>
      </table>
    </div></td>
</tr>
			<?php
		}
			
		
	}
	/* indent complete list */
	function get_indent_order_compleate_list()
	{
		
		$to_date=date('Y-m-d',strtotime($this->input->post('to_date')));
		$from_date=date('Y-m-d',strtotime($this->input->post('from_date')));
		$location_from_uid=$_SESSION['pab_sessionLogInfo']['clinicId'];
		//$store_uid=$this->input->post('store_uid');
		$indent_type='1';
		$indent_no="";
		$indent_status=1;
		$data=$this->Sales_data_fetch_model->fetch_indent_order_list($to_date,$from_date,$indent_type,$location_from_uid,$indent_no,$indent_status);
		$k=0;
		$oldIndent=0;
		$newIndent=0;
		$noOfIndent=0;
		$color=2;		
		foreach($data as $record)
		{
		    
			$k++;
			//$response1=$this->Sales_data_fetch_model->fetch_store_name($record->location_uid_to);
		
			
			switch($record->status)
			{
				case 0:
					$statusTxt="Create";
					break;
				case 1:
					$statusTxt="Completed";
					break;
				case 2:
					$statusTxt="Reject";
					break;					
									
			}
			 
			
				
			
					?>
				<tr>
  <td><?php echo $k;?></td>
  <td  ><a  data-bs-toggle="collapse" data-bs-target="#demo<?php echo $k;?>" class="accordion-toggle cursor-pointer " style="cursor: pointer;height: auto;
  margin-left: 5px;"><?php echo $record->uid;?></a></td>
  <td><?php echo get_clinic_code($record->location_uid_to); ?></td>
  <td><?php echo $record->indent_date;?></td>
  <td><?php if($record->priority==1){?>
    Low
    <?php }if($record->priority==2){?>
    Medium
    <?php }if($record->priority==3){?>
    High
    <?php }?></td>
  <td><?php echo $record->remarks;?></td>
  <td><?=ucwords(get_employee_name($record->created_by))?></td>
  <td><?=ucwords(get_employee_name($record->approved_by))?></td>
  
</tr>
<tr>
  <td  colspan="7" class="hiddenRow"><div class="accordian-body collapse blue_box" id="demo<?php echo $k;?>" style="background-color: rgb(133, 218, 228);">
      <table class="table table-hover  table-condensed hidden_table" >
        <tr class="">
            <td>Item</td>
            <td>Quantity</td>
			<td>Status</td>
          </tr>
        <tbody>
		<?php
		$indent_uid=$record->uid;
		$data=$this->Sales_data_fetch_model->fetch_indent_details_list($indent_uid);
		foreach($data as $record)
		{
			switch($record->status)
			{
				case 0:
					$statusTxt="Create";
					break;
				case 1:
					$statusTxt="Approved";
					break;
				case 2:
					$statusTxt="Reject";
					break;					
									
			}
		?>
		
          <tr>
            <td><?php echo $record->item_name;?></td>
            <td><?php echo $record->indent_quantity;?></td>
           <td><?=$statusTxt;?></td>
          </tr>
		  <?php 
		}
		  ?>
          
        </tbody>
      </table>
    </div></td>
</tr>
			<?php
		}
				
	}
	
	/*indent rejected list*/
function get_indent_order_rejected_list()
	{
		
		$to_date=date('Y-m-d',strtotime($this->input->post('to_date')));
		$from_date=date('Y-m-d',strtotime($this->input->post('from_date')));
		$location_from_uid=$_SESSION['pab_sessionLogInfo']['clinicId'];
		//$store_uid=$this->input->post('store_uid');
		$indent_type='1';
		$indent_no="";
		$indent_status=2;
		$data=$this->Sales_data_fetch_model->fetch_indent_order_list($to_date,$from_date,$indent_type,$location_from_uid,$indent_no,$indent_status);
		$k=0;
		$oldIndent=0;
		$newIndent=0;
		$noOfIndent=0;
		$color=2;		
		foreach($data as $record)
		{
		    
			$k++;
			//$response1=$this->Sales_data_fetch_model->fetch_store_name($record->location_uid_to);
		
			
			switch($record->status)
			{
				case 0:
					$statusTxt="Create";
					break;
				case 1:
					$statusTxt="Completed";
					break;
				case 2:
					$statusTxt="Reject";
					break;					
									
			}
			  
				
			
					?>
				<tr>
  <td><?php echo $k;?></td>
  <td  ><a  data-bs-toggle="collapse" data-bs-target="#demo<?php echo $k;?>" class="accordion-toggle cursor-pointer " style="cursor: pointer;height: auto;
  margin-left: 5px;"><?php echo $record->uid;?></a></td>
  <td><?php echo get_clinic_code($record->location_uid_to); ?></td>
  <td><?php echo $record->indent_date;?></td>
  <td><?php if($record->priority==1){?>
    Low
    <?php }if($record->priority==2){?>
    Medium
    <?php }if($record->priority==3){?>
    High
    <?php }?></td>
  <td><?php echo $record->remarks;?></td>
  <td><?=ucwords(get_employee_name($record->created_by))?></td>
  <td><?=ucwords(get_employee_name($record->approved_by))?></td>
  
</tr>
<tr>
  <td  colspan="7" class="hiddenRow"><div class="accordian-body collapse blue_box" id="demo<?php echo $k;?>" style="background-color: rgb(133, 218, 228);">
      <table class="table table-hover  table-condensed hidden_table" >
        <tr class="">
            <td>Item</td>
            <td>Quantity</td>
			<td>Status</td>
          </tr>
        <tbody>
		<?php
		$indent_uid=$record->uid;
		$data=$this->Sales_data_fetch_model->fetch_indent_details_list($indent_uid);
		foreach($data as $record)
		{
			switch($record->status)
			{
				case 0:
					$statusTxt="Create";
					break;
				case 1:
					$statusTxt="Completed";
					break;
				case 2:
					$statusTxt="Reject";
					break;					
									
			}
		?>
		
          <tr>
            <td><?php echo $record->item_name;?></td>
            <td><?php echo $record->indent_quantity;?></td>
           <td><?=$statusTxt;?></td>
          </tr>
		  <?php 
		}
		  ?>
          
        </tbody>
      </table>
    </div></td>
</tr>
			<?php
		}
				
	}
	
	public function indentApproved()
		{
			$data = array();
			$data['module']=$this->Common_data_fetch_model->fetch_all_modules($service_relationship_uid=0);
			$this->template->load('layout_sales', 'indent_approved', $data);
			
		}
		function get_indent_today_order_list()
	{
		
		$to_date=date('Y-m-d',strtotime($this->input->post('to_date')));
		$from_date=date('Y-m-d',strtotime($this->input->post('from_date')));
		$location_from_uid=$_SESSION['pab_sessionLogInfo']['clinicId'];
		//$store_uid=$this->input->post('store_uid');
		$indent_type='1';
		$indent_no="";
		$indent_status=0;
		$data=$this->Sales_data_fetch_model->fetch_indent_order_list($to_date,$from_date,$indent_type,$location_from_uid,$indent_no,$indent_status);
		$k=0;
		$oldIndent=0;
		$newIndent=0;
		$noOfIndent=0;
		$color=2;		
		foreach($data as $record)
		{
		    
			$k++;
			//$response1=$this->Sales_data_fetch_model->fetch_store_name($record->location_uid_to);
		
			
			switch($record->status)
			{
				case 0:
					$statusTxt="Create";
					break;
				case 1:
					$statusTxt="Completed";
					break;
				case 2:
					$statusTxt="Reject";
					break;					
									
			}
			  
			
				
			
					?>
				<tr>
  <td><?php echo $k;?></td>
  <td  ><a  data-bs-toggle="collapse" data-bs-target="#demo<?php echo $k;?>" class="accordion-toggle cursor-pointer" style="cursor: pointer;height: auto;
  margin-left: 5px;"><?php echo $record->uid;?></a> <!--<a  class="btn custom_button" onclick="popup_print(<?php echo $record->uid;?>)"><i class="fa fa-print" aria-hidden="true"></i></a>--></td>
  <td><?php echo get_clinic_code($record->location_uid_to); ?></td>
  <td><?php echo $record->indent_date;?></td>
  <td><?php if($record->priority==1){?>
    Low
    <?php }if($record->priority==2){?>
    Medium
    <?php }if($record->priority==3){?>
    High
    <?php }?></td>
  <td><?php echo $record->remarks;?></td>
  <td><?=ucwords(get_employee_name($record->created_by))?></td>
  <td><input type="checkbox" class="create_checkbox" id="" name="indent_action[]" value="<?=$record->uid?>"></td>
</tr>
<tr>
  <td  colspan="8" class="hiddenRow"><div class="accordian-body collapse blue_box" id="demo<?php echo $k;?>" style="background-color: rgb(133, 218, 228);">
      <table class="table table-hover  table-condensed hidden_table" >
        <tr class="">
            <td>Item</td>
            <td>Quantity</td>
			<td>Status</td>
          </tr>
        <tbody>
		<?php
		$indent_uid=$record->uid;
		$data=$this->Sales_data_fetch_model->fetch_indent_details_list($indent_uid);
		
		foreach($data as $record)
		{
			switch($record->status)
			{
				case 0:
					$statusTxt="Pending";
					break;
				case 1:
					$statusTxt="Processing";
					break;
				case 2:
					$statusTxt="Completed";
					break;					
									
			}
		?>
		
          <tr>
            <td><?php echo $record->item_name;?></td>
            <td><?php echo $record->indent_quantity;?></td>
           <td><?=$statusTxt;?></td>
          </tr>
		  <?php 
		}
		  ?>
          
        </tbody>
      </table>
    </div></td>
</tr>
			<?php
		}
			
		
	}
	function indent_accept_reject()
	{
		$to_date=$this->input->post('to_date');
		$from_date=$this->input->post('from_date');
		$indent_action=$this->input->post('indent_action');
		$indent_sttus=$this->input->post('indent_sttus');
		for($i=0;$i<count($this->input->post('indent_action'));$i++)
		{
			if($indent_action[$i]>0)
				{
			$data=array(
				'status'=>$indent_sttus,
				'approved_by'=>$_SESSION['pab_sessionLogInfo']['loggedUserId']
			);
			$this->Common_data_add_model->update_data($data,'inventory_indent','uid',$indent_action[$i]);
				}
		}
		if($indent_sttus==1)
		{
		$this->session->set_flashdata('success', 'Indent Approved');
		}
		else{
			$this->session->set_flashdata('success', 'Indent Rejected');
		}
		redirect(base_url()."sales/indent");
	}
	
	public function goodsReceived()
	{
		$data = array();
			$data['module']=$this->Common_data_fetch_model->fetch_all_modules($service_relationship_uid=0);
		$this->template->load('layout_sales', 'goods_received', $data);
	}
	function get_goods_received_list()
	{
		$to_date=date('Y-m-d',strtotime($this->input->post('to_date')));
		$from_date=date('Y-m-d',strtotime($this->input->post('from_date')));
		$location_uid=$this->input->post('location_uid');
		$data=$this->Sales_data_fetch_model->fetch_approved_indent_list($from_date,$to_date,$location_uid);

		$sl=0;
		if(!empty($data))
		{
			foreach($data as $record)
			{
		?>
				<tr>
					<td><?=$record->uid?></td>				
					<td><?=$record->indent_uid?></td>
					<td><?=$record->doi?></td>					
					<td><?=$record->store_name?></td>									
					<td><button type="button" class="btn from_button" onclick="select_issue(<?=$record->uid?>)">Select</button></td>
										
				</tr>
		<?php
			}
		}		
	}
	function get_issue_list()
	{
		
		$issue_id=$this->input->post('issue_id');
		$data=$this->Sales_data_fetch_model->fetch_indent_issue_list($issue_id);

		$sl=0;
		if(!empty($data))
		{
			foreach($data as $record)
			{
		?>
				<tr>
					<td><?=++$sl;?></td>
					<td><?=$record->indent_uid?></td>
					<td><?=$record->doi?></td>
					<?php
					//get item name
					
						$dataItem=$this->Sales_data_fetch_model->fetch_medicine_record($record->item_uid);
						echo '<td>'.$dataItem->item_name.'</td>';
					
					?>
					
					<td><?=$record->quantity?></td>
					<td><?=$record->store_name?></td>
										
					<td><?php
					if($record->is_goodsReceived==0)
					{					
					?>
					<input class="form-control" type="hidden" id="item_uid" name="item_uid[]" value="<?=$record->item_uid;?>">
					<input class="form-control" type="hidden" id="indent_uid" name="indent_uid[]" value="<?=$record->indent_uid;?>">
					<input type="checkbox" checked="checked" id="checkItem" name="issue_check[]" value="<?=$record->uid?>"><?php
					}
					?></td>
										
				</tr>
		<?php
			}
		}
	
	}
	function accept_issue_new()
	{
		$issue_check=$this->input->post('issue_check');
		$item_uid=$this->input->post('item_uid');
		$indent_uid=$this->input->post('indent_uid');
		$locationId=$_SESSION['pab_sessionLogInfo']['clinicId'];
		for($i=0;$i<count($this->input->post('issue_check'));$i++)
		{
			if($issue_check[$i]>0)
				{
			$data=array(
				'is_goodsReceived'=>1
			);
			$this->Common_data_add_model->update_data($data,'inventory_stock_issue_details','uid',$issue_check[$i]);
			
			$indent_details_data=array(
				'status'=>1
			);
			$this->Common_data_add_model->update_data($indent_details_data,'inventory_indent_details','item_uid',$item_uid[$i],'indent_uid',$indent_uid[$i],'location_uid_from',$locationId);
				}
		}
		
		
		$this->session->set_flashdata('success', 'Data Saved...');	
		
		redirect(base_url()."sales/goodsReceived");		
	}
	
	public function regularBill()
	{
		$data = array();
			$data['module']=$this->Common_data_fetch_model->fetch_all_modules($service_relationship_uid=0);
			$data['all_items_dd']=$this->Sales_data_fetch_model->fetch_items_dd();
		$data['all_doctors_dd']=$this->Sales_data_fetch_model->fetch_all_doctors_name_dd();
		$data['bank_name_listDD']=$this->Common_data_fetch_model->fetch_misc_details_dropdown(104);//bank name list
		$data['wallet_name_listDD']=$this->Common_data_fetch_model->fetch_misc_details_dropdown(108);
		$this->template->load('layout_sales', 'regular_bill', $data);
	}
	function get_item_stock_rate()
	{
	$return_stat='0';
	$item_uid=$this->input->post('item_uid');
	$location_uid=$_SESSION['pab_sessionLogInfo']['clinicId'];
		$this->load->library('CustomInventoryLib');
		$myLib = new CustomInventoryLib();
		//get counter stock
		$currentCounterStock=$myLib->getLocationStock($item_uid,$return_flag=1,$batch_no="",$location_uid,$location_type=1);//return required			
//$totalSale=$this->Sales_data_fetch_model->fetch_item_total_sale($item_uid);
		if($return_stat=="0")
		{
			if($currentCounterStock>0)
			{
				$item_responseData=$this->Common_data_fetch_model->fetch_master_record($table='master_item',$select_fields_string='*',$search_filed='uid',$search_field_value=$item_uid,$is_like_search=0,$is_return_type_row=1);
				$response = [
				'mrp' => $item_responseData->mrp,
				'stock' => $currentCounterStock
				];

				echo json_encode($response);
			}
			else
			{
				echo 0;
			}
		}
		
	
	}
	function saveBill()
	{
		
		$this->load->helper(array('form', 'url'));
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('<span style="color:red">', '</span>');
		$this->form_validation->set_rules('patient_name', 'Patient Name', 'required');
		$this->form_validation->set_rules('gender', 'Gender', 'required|numeric');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|numeric|exact_length[10]');
		$this->form_validation->set_rules('city', 'City', 'required|alpha');

		if($this->form_validation->run()!= FALSE)
		{		
			$item_array=$this->input->post('item_uid');			
			$row_gross_array=$this->input->post('gross');		
			$row_discount_array=$this->input->post('discount');		
			$row_net_array=$this->input->post('net');		
			
			$gross_amount=$this->input->post('gross_amount');
			$totItm_discount_amount=$this->input->post('totItm_discount_amount');
			$net_amount=$this->input->post('net_amount');
			
			$cash_amount=$this->input->post('cash_amount');
			$cheque_amount=$this->input->post('cheque_amount');
			$card_amount=$this->input->post('card_amount');
			$bank_transfer_amount=$this->input->post('bank_transfer_amount');
			$settlement_amount=$this->input->post('settlement_amount');
			$upi_wallet_amount=$this->input->post('upi_wallet_amount');

			$quantity_array=$this->input->post('quantity');
			$total_gross_amount=0;
			$total_net_amount=0;
			$total_paid_amount=0;
			$totalCalculatedItemDiscount=0;
			$special_discount_amount=0;
			$special_discount_reason="";
			$special_discount_approved_by=-1;
			$hd_date="";
			$agent=-1;
			foreach($row_gross_array as $key=>$value)
				$total_gross_amount+=$value;
			foreach($row_net_array as $key=>$value)
				$total_net_amount+=$value;
			
$total_paid_amount = 
    (float)$cash_amount + 
    (float)$cheque_amount + 
    (float)$card_amount + 
    (float)$bank_transfer_amount + 
    (float)$settlement_amount + 
    (float)$upi_wallet_amount;

				//$total_paid_amount=$cash_amount+$cheque_amount+$card_amount+$bank_transfer_amount+$settlement_amount+$upi_wallet_amount;
				
		
			//total item discount
			for($i=0;$i<count($row_discount_array);$i++)
			{
				$totalCalculatedItemDiscount+=$row_discount_array[$i];
			}
			
			$payble_amount=$total_net_amount;

			$hd_date="";

			$treating_doctor=$this->input->post('treating_doctor');
			
			//invoice no
			$selected_clinic_uid=$_SESSION['pab_sessionLogInfo']['clinicId'];//101;
			//get last invoice no against clinic uid
			$last_inv_response=$this->Sales_data_fetch_model->fetch_last_invoice_no($selected_clinic_uid);
			$current_invoice_no=($last_inv_response->last_invoice_no)+1;
			
			
			//financial year
			if((date('m')>=4) && (date('m')<=12))
			{
				$fy=date('Y').(date('Y')+1);
			}
			if((date('m')>=1) && (date('m')<=3))
			{
				$fy=(date('Y')-1).date('Y');
			}
		
			
			//save into billing master
				$data3=array(
					"bill_prefix"=>"OPBL/",
					"invoice_no"=>$current_invoice_no,
					"full_name"=>$this->input->post('patient_name'),
					"mobile"=>$this->input->post('mobile'),
					"city"=>$this->input->post('city'),
					"address1"=>$this->input->post('address1'),
					"gender"=>$this->input->post('gender'),
					"appointmentBooking_uid"=>0,
					"clinic_uid"=>$_SESSION['pab_sessionLogInfo']['clinicId'],
					"treating_doctor"=>$treating_doctor,
					"sponsor_uid"=>0,
					"bill_section"=>1,
					"entry_by"=>$_SESSION['pab_sessionLogInfo']['loggedUserId'],
					"gross_amount"=>$total_gross_amount,
					"discount_amount"=>$special_discount_amount+$totalCalculatedItemDiscount,
					"net_amount"=>$payble_amount-$special_discount_amount,
					"fy"=>$fy,
					"token_no"=>0,
					"entry_date_time"=>date('Y-m-d H:i:s'),
					"bill_date"=>date('Y-m-d')

				);
				if($this->input->post('printAsDietChart'))
					$data3['printAsDiet']=$this->input->post('printAsDietChart');
				else
					$data3['printAsDiet']=0;

				//insert record to billing table
				$billmast_uid=$this->Common_data_add_model->save_data($data3,'billing_master');

				$billno="OPBL/".$current_invoice_no;	
				//billing table insert start
				//count no of record in service array
				$item_array_len=count($item_array);
				$service_arr_net_amount=0;
				$inv_counter=0;
				for($i=0;$i<$item_array_len;$i++)
				{
					$service_date=date('Y-m-d');
					$agent_id=0;

					$data=array(
						"billmast_uid"=>$billmast_uid,
						"bill_no"=>$billno,
						"treating_doctor"=>$treating_doctor,
						"service_uid"=>0,
						"patient_uid"=>0,
						"clinic_uid"=>$_SESSION['pab_sessionLogInfo']['clinicId'],
						"agent_uid"=>$agent_id,
						"sponsor_uid"=>0,
						"sale_category"=>1,
						"entry_by"=>$_SESSION['pab_sessionLogInfo']['loggedUserId'],	
						"entry_date_time"=>date('Y-m-d H:i:s'),						
						"quantity"=>$quantity_array[$i],
						"service_amount"=>$row_gross_array[$i],
						"discount_amount"=>$row_discount_array[$i],
						"gross_amount"=>$row_net_array[$i],
						"urgent_flag"=>0,
						"fy"=>$fy,
						"date_of_service"=>date('Y-m-d'),
						"bill_date"=>date('Y-m-d')
					);
					
					$data += ["item_id" => base64_decode($item_array[$i])];
					
					//insert record to billing table
					$this->Common_data_add_model->save_data($data,'billing');
					$service_arr_net_amount+=$row_net_array[$i];
				}

				//get last invoice no against clinic uid
				$last_receipt_response=$this->Sales_data_fetch_model->fetch_last_receipt_no($selected_clinic_uid);
				$current_receipt_no=($last_receipt_response->last_receipt_no)+1;						
				
				$pdata=array(
						"receipt_prefix"=>"OPRC/",
						"billmast_uid"=>$billmast_uid,
						"bill_no"=>$billno,
						"receipt_no"=>$current_receipt_no,
						"payment_mode"=>0,
						"net_amount"=>$total_paid_amount,
						"cash_mode"=>$cash_amount,
						"card_mode"=>$card_amount,
						"cheque_mode"=>$cheque_amount,
						"bank_transfer_mode"=>$bank_transfer_amount,
						"advance_mode"=>$settlement_amount,
						"upi_wallet_mode"=>$upi_wallet_amount,
						
						"card_instrument_no"=>0,
						"instrument_date"=>date('Y-m-d'),
						"voucher_date"=>date('Y-m-d'),
						"voucher_time"=>date('H:i:s'),
						"patient_uid"=>0,
						"clinic_uid"=>$_SESSION['pab_sessionLogInfo']['clinicId'],
						"fy"=>$fy,
						"entry_by"=>$_SESSION['pab_sessionLogInfo']['loggedUserId'],
						"entry_date_time"=>date('Y-m-d H:i:s')					
					);			
				
				$rcpt_id=$this->Common_data_add_model->save_data($pdata,'bill_receipt');

				$payment_arr_net_amount=$total_paid_amount;
				
				//update payment flag
				$pflagData=array(
						"payment_flag"=>1				
					);
				$this->Common_data_add_model->update_data($pflagData,'billing','billmast_uid',$billmast_uid);	

				
				
				//set temp session to print bill
				$this->session->set_flashdata('temp_print_bill_no', $billmast_uid);

				redirect(base_url('sales/regularBill'));
		}
		else
		{
			$data=array();
		//get all items
		$data['module']=$this->Common_data_fetch_model->fetch_all_modules($service_relationship_uid=0);
			$data['all_items_dd']=$this->Sales_data_fetch_model->fetch_items_dd();
		$data['all_doctors_dd']=$this->Sales_data_fetch_model->fetch_all_doctors_name_dd();
		$data['bank_name_listDD']=$this->Common_data_fetch_model->fetch_misc_details_dropdown(104);//bank name list
		$data['wallet_name_listDD']=$this->Common_data_fetch_model->fetch_misc_details_dropdown(108);
		$this->template->load('layout_sales', 'regular_bill', $data);
		}
	}
	function printBill($bill_no)
	{
		//get patient personal details and invoice no and invoice date
		$data['clinic_details']=$this->Sales_data_fetch_model->fetch_clinic_by_id($_SESSION['pab_sessionLogInfo']['clinicId']);

		//get patient personal details and invoice no and invoice date
		$data['patient_billing_master_data']=$this->Sales_data_fetch_model->fetch_bill_master_details($bill_no);

		$data['patient_personal_invoice_record']=$this->Sales_data_fetch_model->fetch_patient_invoice_details($bill_no);
		//print_r($data);die();
//echo $this->db->last_query();die();
		$data['bill_date_time_record']=$this->Sales_data_fetch_model->fetch_bill_date_time($bill_no);

		//get employee name
		$data['billEmployeeRecord']=$this->Sales_data_fetch_model->fetch_employee_record($data['patient_billing_master_data']->entry_by);

		//get patient payment details
		
		$payment_details=$this->Sales_data_fetch_model->fetch_patient_payment_details($bill_no);
		$pdata=[];
		foreach($payment_details as $record)
		{
			if($record->cash_mode>0)
			{			
				$pdata[]=(object)array(
					"mode"=>'Cash',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->cash_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}
			if($record->card_mode>0)
			{
				$pdata[]=(object)array(
					"mode"=>'Card',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->card_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}
			if($record->cheque_mode>0)
			{			
				$pdata[]=(object)array(
					"mode"=>'Cheque',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->cheque_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}			
			if($record->bank_transfer_mode>0)
			{			
				$pdata[]=(object)array(
					"mode"=>'NEFT/RTGS',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->bank_transfer_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}
			if($record->advance_mode>0)
			{			
				$pdata[]=(object)array(
					"mode"=>'Advance',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->advance_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}
			if($record->upi_wallet_mode>0)
			{
				$pdata[]=(object)array(
					"mode"=>'UPI/Wallet',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->upi_wallet_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}			
		}
		$data['patient_payment_details']=$pdata;
		//print_r($data['patient_payment_details']);die();
		
		$data['patient_billing_master_details']=$this->Sales_data_fetch_model->fetch_patient_billing_master_details($bill_no);

		$this->load->view('sales/print_bill',$data);
	
	}
	
	function fetch_sex_txt($sex_code)
	{
		switch($sex_code)
		{
			case 1:
				$sextxt="Female";
				break;
			case 2:
				$sextxt="Male";
				break;
			case 3:
				$sextxt="Transgender";
				break;	
		}
		return $sextxt;
	}
	
	function billRegister()
	{
	$data=array();
		//get all items
		$data['module']=$this->Common_data_fetch_model->fetch_all_modules($service_relationship_uid=0);
			
		$this->template->load('layout_sales', 'bill_list', $data);
	}
	function get_bill_list()
	{
		$search_parameter=$this->input->post();
		$bill_list_response=$this->Sales_data_fetch_model->fetch_bill_list($search_parameter);

		if(!empty($bill_list_response))
		{
			$sl=0;
			foreach($bill_list_response as $record)
			{
				if($record->cancel_flag==1)
				{
					echo '<tr style="background:#fd9088">';
				}
				else if($record->bill_section==4)
					{
						echo '<tr style="background:#a9e9ed">';
					}
				else				
				{
				?>
				<tr>
				<?php
				}
				?>
					<td scope="row"><?=++$sl;?></td>
					<td scope="row"><?=$record->bill_prefix.$record->invoice_no?></td>
					<td scope="row"><?=date('d-m-Y',strtotime($record->bill_date))?></td>			
					<td scope="row"><?=$record->patient_uid?></td>			
					<td scope="row" width="30%" style="font-weight: bold"><?=$record->full_name?> | <?=(($record->gender==1)?'F':(($record->gender==2)?'M':'T'))?> | <?=$record->mobile?></td>
					<td scope="row"><?php 
							if($record->bill_section==1)
							{
							?>
							<?=$record->gross_amount?>
							<?php 
							}
							else 
							{
								echo "0";
							}
						?></td>
					<td scope="row">
					<?php 
							if($record->bill_section==1)
							{
							?>
					<?=$record->discount_amount?>
					<?php 
							}
							else 
							{
								echo "0";
							}
						?>
					</td>
					<td scope="row">
					<?php 
							if($record->bill_section==1)
							{
							?>
					<?=$record->net_amount?>
					<?php 
							}
							else 
							{
								echo "0";
							}
						?>
					</td>
					<td scope="row" width="15%">
					<?php
					if($record->cancel_flag==0)
					{					
					?>					
					<a class="btn custom_button" href="<?=base_url()?>sales/<?=($record->bill_section==1)?'printBill':(($record->bill_section==4)?'printComplementaryBill':'printBill')?>/<?=$record->uid?>" target="blank" title="Reprint">
						<i class="fa fa-print" aria-hidden="true"></i> Reprint
					</a>

					<?php
					}
					?>					
					</td>
				</tr>				
				<?php
				if($record->cancel_flag==0 && $record->bill_section==1)
				{
					$total_gross_amount+=$record->gross_amount;
					$total_discount+=$record->discount_amount;
					$total_net+=$record->net_amount;
				}
			}
			?>
			<tr>
			<td  colspan="6"></td>
			<td ><strong><?php echo number_format((float)$total_gross_amount, 2, '.', '');?></strong></td>
			<td ><strong><?php echo number_format((float)$total_discount, 2, '.', '');?></strong></td>
			<td ><strong><?php echo number_format((float)$total_net, 2, '.', '');?></strong></td>
			</tr>			
			<?php
		}
		else
		{
			?>
			  <tr>
				<td colspan="9"><?="Data not available"?></td>
			  </tr>			
			<?php
		}
	}
	
	function closingStock()
	{
	$data=array();
		//get all items
		$data['module']=$this->Common_data_fetch_model->fetch_all_modules($service_relationship_uid=0);
			
		$this->template->load('layout_sales', 'closing_stock', $data);
	}
	
	function get_closing_stock_list()
	{
	$location_uid=$this->input->post('clinic_uid');
	$responseData=$this->Sales_data_fetch_model->fetch_closing_stock_list();
			//echo $this->db->last_query();			
			if(!empty($responseData))
			{	
				$sl=0;
				foreach($responseData as $record)
				{
					$sl++;
					$return_stat='0';
	$item_uid=$record->uid;
	
		$this->load->library('CustomInventoryLib');
		$myLib = new CustomInventoryLib();
		//get counter stock
		$currentCounterStock=$myLib->getLocationStock($item_uid,$return_flag=1,$batch_no="",$location_uid,$location_type=1);//return required	
					?>
					<tr>
					<td><?=$sl?></td>
					<td><?=$record->item_name?></td>
					<td>
						<?=$currentCounterStock?>
					</td>
					
					</tr>
					<?php
				}
		
			}
	}
	public function complimentaryBill()
	{
		$data = array();
			$data['module']=$this->Common_data_fetch_model->fetch_all_modules($service_relationship_uid=0);
			$data['all_items_dd']=$this->Sales_data_fetch_model->fetch_items_dd();
		$data['all_doctors_dd']=$this->Sales_data_fetch_model->fetch_all_doctors_name_dd();
		$data['bank_name_listDD']=$this->Common_data_fetch_model->fetch_misc_details_dropdown(104);//bank name list
		$data['wallet_name_listDD']=$this->Common_data_fetch_model->fetch_misc_details_dropdown(108);
		$this->template->load('layout_sales', 'complimentary_bill', $data);
	}
	
	function saveComplimentaryBill()
	{
		
		$this->load->helper(array('form', 'url'));
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('<span style="color:red">', '</span>');
		$this->form_validation->set_rules('patient_name', 'Patient Name', 'required');
		$this->form_validation->set_rules('gender', 'Gender', 'required|numeric');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|numeric|exact_length[10]');
		$this->form_validation->set_rules('city', 'City', 'required|alpha');

		if($this->form_validation->run()!= FALSE)
		{		
			$item_array=$this->input->post('item_uid');			
			$row_gross_array=$this->input->post('gross');		
			$row_discount_array=$this->input->post('discount');		
			$row_net_array=$this->input->post('net');		
			
			$gross_amount=$this->input->post('gross_amount');
			$totItm_discount_amount=$this->input->post('totItm_discount_amount');
			$net_amount=$this->input->post('net_amount');
			
			$cash_amount=$this->input->post('cash_amount');
			$cheque_amount=$this->input->post('cheque_amount');
			$card_amount=$this->input->post('card_amount');
			$bank_transfer_amount=$this->input->post('bank_transfer_amount');
			$settlement_amount=$this->input->post('settlement_amount');
			$upi_wallet_amount=$this->input->post('upi_wallet_amount');

			$quantity_array=$this->input->post('quantity');
			$complementary_resion=$this->input->post('complementary_resion');
			$total_gross_amount=0;
			$total_net_amount=0;
			$total_paid_amount=0;
			$totalCalculatedItemDiscount=0;
			$special_discount_amount=0;
			$special_discount_reason="";
			$special_discount_approved_by=-1;
			$hd_date="";
			$agent=-1;
			foreach($row_gross_array as $key=>$value)
				$total_gross_amount+=$value;
			foreach($row_net_array as $key=>$value)
				$total_net_amount+=$value;
			
$total_paid_amount = 
    (float)$cash_amount + 
    (float)$cheque_amount + 
    (float)$card_amount + 
    (float)$bank_transfer_amount + 
    (float)$settlement_amount + 
    (float)$upi_wallet_amount;

				//$total_paid_amount=$cash_amount+$cheque_amount+$card_amount+$bank_transfer_amount+$settlement_amount+$upi_wallet_amount;
				
		
			//total item discount
			for($i=0;$i<count($row_discount_array);$i++)
			{
				$totalCalculatedItemDiscount+=$row_discount_array[$i];
			}
			
			$payble_amount=$total_net_amount;

			$hd_date="";

			$treating_doctor=$this->input->post('treating_doctor');
			
			//invoice no
			$selected_clinic_uid=$_SESSION['pab_sessionLogInfo']['clinicId'];//101;
			//get last invoice no against clinic uid
			$last_inv_response=$this->Sales_data_fetch_model->fetch_last_invoice_no($selected_clinic_uid);
			$current_invoice_no=($last_inv_response->last_invoice_no)+1;
			
			
			//financial year
			if((date('m')>=4) && (date('m')<=12))
			{
				$fy=date('Y').(date('Y')+1);
			}
			if((date('m')>=1) && (date('m')<=3))
			{
				$fy=(date('Y')-1).date('Y');
			}
		
			
			//save into billing master
				$data3=array(
					"bill_prefix"=>"OPBL/",
					"invoice_no"=>$current_invoice_no,
					"full_name"=>$this->input->post('patient_name'),
					"mobile"=>$this->input->post('mobile'),
					"city"=>$this->input->post('city'),
					"address1"=>$this->input->post('address1'),
					"gender"=>$this->input->post('gender'),
					"appointmentBooking_uid"=>0,
					"clinic_uid"=>$_SESSION['pab_sessionLogInfo']['clinicId'],
					"treating_doctor"=>$treating_doctor,
					"sponsor_uid"=>0,
					"bill_section"=>4,
					"entry_by"=>$_SESSION['pab_sessionLogInfo']['loggedUserId'],
					"gross_amount"=>$total_gross_amount,
					"discount_amount"=>$special_discount_amount+$totalCalculatedItemDiscount,
					"net_amount"=>$payble_amount-$special_discount_amount,
					"discount_reason"=>$complementary_resion,
					"fy"=>$fy,
					"token_no"=>0,
					"entry_date_time"=>date('Y-m-d H:i:s'),
					"bill_date"=>date('Y-m-d')

				);
				if($this->input->post('printAsDietChart'))
					$data3['printAsDiet']=$this->input->post('printAsDietChart');
				else
					$data3['printAsDiet']=0;

				//insert record to billing table
				$billmast_uid=$this->Common_data_add_model->save_data($data3,'billing_master');

				$billno="OPBL/".$current_invoice_no;	
				//billing table insert start
				//count no of record in service array
				$item_array_len=count($item_array);
				$service_arr_net_amount=0;
				$inv_counter=0;
				for($i=0;$i<$item_array_len;$i++)
				{
					$service_date=date('Y-m-d');
					$agent_id=0;

					$data=array(
						"billmast_uid"=>$billmast_uid,
						"bill_no"=>$billno,
						"treating_doctor"=>$treating_doctor,
						"service_uid"=>0,
						"patient_uid"=>0,
						"clinic_uid"=>$_SESSION['pab_sessionLogInfo']['clinicId'],
						"agent_uid"=>$agent_id,
						"sponsor_uid"=>0,
						"sale_category"=>1,
						"entry_by"=>$_SESSION['pab_sessionLogInfo']['loggedUserId'],	
						"entry_date_time"=>date('Y-m-d H:i:s'),						
						"quantity"=>$quantity_array[$i],
						"service_amount"=>$row_gross_array[$i],
						"discount_amount"=>$row_discount_array[$i],
						"gross_amount"=>$row_net_array[$i],
						"urgent_flag"=>0,
						"fy"=>$fy,
						"date_of_service"=>date('Y-m-d'),
						"bill_date"=>date('Y-m-d')
					);
					
					$data += ["item_id" => base64_decode($item_array[$i])];
					
					//insert record to billing table
					$this->Common_data_add_model->save_data($data,'billing');
					$service_arr_net_amount+=$row_net_array[$i];
				}

				

				$payment_arr_net_amount=$total_paid_amount;
				
				//update payment flag
				$pflagData=array(
						"payment_flag"=>1				
					);
				$this->Common_data_add_model->update_data($pflagData,'billing','billmast_uid',$billmast_uid);	

				
				
				//set temp session to print bill
				$this->session->set_flashdata('temp_print_bill_no', $billmast_uid);

				redirect(base_url('sales/complimentaryBill'));
		}
		else
		{
			$data=array();
		//get all items
		$data['module']=$this->Common_data_fetch_model->fetch_all_modules($service_relationship_uid=0);
			$data['all_items_dd']=$this->Sales_data_fetch_model->fetch_items_dd();
		$data['all_doctors_dd']=$this->Sales_data_fetch_model->fetch_all_doctors_name_dd();
		$data['bank_name_listDD']=$this->Common_data_fetch_model->fetch_misc_details_dropdown(104);//bank name list
		$data['wallet_name_listDD']=$this->Common_data_fetch_model->fetch_misc_details_dropdown(108);
		$this->template->load('layout_sales', 'complimentary_bill', $data);
		}
	}
	function printComplementaryBill($bill_no)
	{
		//get patient personal details and invoice no and invoice date
		$data['clinic_details']=$this->Sales_data_fetch_model->fetch_clinic_by_id($_SESSION['pab_sessionLogInfo']['clinicId']);

		//get patient personal details and invoice no and invoice date
		$data['patient_billing_master_data']=$this->Sales_data_fetch_model->fetch_bill_master_details($bill_no);

		$data['patient_personal_invoice_record']=$this->Sales_data_fetch_model->fetch_patient_invoice_details($bill_no);
		//print_r($data);die();
//echo $this->db->last_query();die();
		$data['bill_date_time_record']=$this->Sales_data_fetch_model->fetch_bill_date_time($bill_no);

		//get employee name
		$data['billEmployeeRecord']=$this->Sales_data_fetch_model->fetch_employee_record($data['patient_billing_master_data']->entry_by);

		//get patient payment details
		
		$payment_details=$this->Sales_data_fetch_model->fetch_patient_payment_details($bill_no);
		$pdata=[];
		foreach($payment_details as $record)
		{
			if($record->cash_mode>0)
			{			
				$pdata[]=(object)array(
					"mode"=>'Cash',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->cash_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}
			if($record->card_mode>0)
			{
				$pdata[]=(object)array(
					"mode"=>'Card',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->card_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}
			if($record->cheque_mode>0)
			{			
				$pdata[]=(object)array(
					"mode"=>'Cheque',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->cheque_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}			
			if($record->bank_transfer_mode>0)
			{			
				$pdata[]=(object)array(
					"mode"=>'NEFT/RTGS',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->bank_transfer_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}
			if($record->advance_mode>0)
			{			
				$pdata[]=(object)array(
					"mode"=>'Advance',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->advance_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}
			if($record->upi_wallet_mode>0)
			{
				$pdata[]=(object)array(
					"mode"=>'UPI/Wallet',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->upi_wallet_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}			
		}
		$data['patient_payment_details']=$pdata;
		//print_r($data['patient_payment_details']);die();
		
		$data['patient_billing_master_details']=$this->Sales_data_fetch_model->fetch_patient_billing_master_details($bill_no);

		$this->load->view('sales/complementary_print_bill',$data);
	
	}
	function billingScroll()
		{
			$data=array();
			$data['module']=$this->Common_data_fetch_model->fetch_all_modules($service_relationship_uid=0);		
			$this->template->load('layout_sales', 'billing_scroll', $data);
		}
		function get_scroll_list()
		{
			$search_parameter=$this->input->post();
			$response=$this->Sales_data_fetch_model->fetch_scroll_list($search_parameter);
			
			//get total service refund amound by user
			//$serviceCancelAmountResponse=$this->Sales_data_fetch_model->fetch_service_cancel_total_amount($search_parameter);		
			
			$serviceCancelAmountResponse=$this->Sales_data_fetch_model->fetch_service_cancel_refund_total_amount(date('Y-m-d',strtotime($this->input->post('from_date'))),date('Y-m-d',strtotime($this->input->post('to_date'))),$_SESSION['pab_sessionLogInfo']['loggedUserId']);			
			
			if(!empty($response))
			{
				foreach($response as $record)
				{
					//$cancelResponse=$this->Sales_data_fetch_model->fetch_cancel_list($search_parameter,$record->voucher_date);						
				?>
				<tr>
					<td width="150"><?=date('d-m-Y',strtotime($record->voucher_date))?></td>
					<td><?=$record->sum_net?></td>
					<td width=""><?=$record->total_cash?></td>
					<td width=""><?=$record->total_card?></td>
					<td width=""><?=$record->total_cheque?></td>
					<td width=""><?=$record->total_bank_transfer?></td>
					<td width=""><?=$record->total_upi_wallet?></td>
					<td width="">0<?php //(!empty($cancelResponse) && $cancelResponse->sum_net>0)?$cancelResponse->sum_net:'0'?></td>
				</tr>
				<?php
				}
			?>
			<tr>
				<td colspan="7">Total Cash Refund: <?=$serviceCancelAmountResponse->serviceCancelledTotalAmount?></td>
			</tr>
			<?php	
			}
		}
		function stockTransfer()
		{
			$data=array();
			$data['module']=$this->Common_data_fetch_model->fetch_all_modules($service_relationship_uid=0);	$data['all_clinic']=$this->Common_data_fetch_model->fetch_clinic();
			unset($data['all_clinic'][$_SESSION['pab_sessionLogInfo']['clinicId']]);
			$data['all_items_dd']=$this->Sales_data_fetch_model->fetch_items_dd();
			$this->template->load('layout_sales', 'stock_transfer', $data);
		}
		
		function saveStockTransfer()
		{
		$item_name_array=$this->input->post('item_uid');	
		$transfer_clinic=$this->input->post('clinic');
		$item_qty_array=$this->input->post('quantity');
		
		$no_item_issued=0;
			for($i=0;$i<count($item_qty_array);$i++)
			{
				if($item_qty_array[$i]>0)
				{
					$no_item_issued=count($item_qty_array);
				}
			}
			if($no_item_issued>0)
				{
			$stock_issueData=array(
			"doi"=>date("Y-m-d"),
				"no_item_issued"=>$no_item_issued,
				"is_transfer"=>1,
				"entry_by"=>$_SESSION['pab_sessionLogInfo']['loggedUserId'],
				"location_uid_to"=>$transfer_clinic,
				"location_uid_from"=>$_SESSION['pab_sessionLogInfo']['clinicId'],
				"entry_date_time"=>date("Y-m-d H:i:s")			
			);
			$stock_issue_order_uid=$this->Common_data_add_model->save_data($stock_issueData,'inventory_stock_issue');
			
		   	for($i=0;$i<count($item_name_array);$i++)
			{
				if($item_qty_array[$i]>0)
				{
			$indentDetailsData=array(
			"issue_uid"=>$stock_issue_order_uid,
				"doi"=>date("Y-m-d"),
				"indent_uid"=>0,
				"item_uid"=>base64_decode($item_name_array[$i]),
				"quantity"=>$item_qty_array[$i],
				"item_type"=>1,
				"is_transfer"=>1,
				"is_goodsReceived"=>0,
				"employee_uid"=>$_SESSION['pab_sessionLogInfo']['loggedUserId'],
				"clinic_uid"=>$_SESSION['pab_sessionLogInfo']['clinicId'],
				"location_uid_to"=>$transfer_clinic,
				"location_uid_from"=>$_SESSION['pab_sessionLogInfo']['clinicId'],
				"entry_date_time"=>date("Y-m-d H:i:s")
				);
			$this->Common_data_add_model->save_data($indentDetailsData,'inventory_stock_issue_details');
			
			
				}
			}
//echo $this->db->last_query();
//die();
			$this->session->set_flashdata('success', 'Data Saved...');
			
			
	}
	redirect(base_url()."sales/stockTransfer");
		
		}
	
	function stockTransferList()
	{
	$data=array();
		//get all items
		$data['module']=$this->Common_data_fetch_model->fetch_all_modules($service_relationship_uid=0);
			
		$this->template->load('layout_sales', 'stock_transfer_list', $data);
	}
	function get_stock_transfer_list()
	{
		$search_parameter=$this->input->post();
		$bill_list_response=$this->Sales_data_fetch_model->fetch_stock_transfer_list($search_parameter);

		if(!empty($bill_list_response))
		{
			$sl=0;
			foreach($bill_list_response as $record)
			{
				
				?>
				<tr>
				
					<td scope="row"><?=++$sl;?></td>
					<td scope="row"><?=date('d-m-Y',strtotime($record->doi))?></td>			
					<td scope="row"><?=get_item_name($record->item_uid)?></td>			
					<td scope="row"><?=$record->quantity?></td>			
					<td scope="row"><?=get_clinic_code($record->location_uid_to)?></td>			
					<td scope="row"><?= ($record->is_goodsReceived == 1) ? 'Received' : 'Pending'; ?></td>			
					
					
				</tr>				
				<?php
				
			}
			?>
						
			<?php
		}
		else
		{
			?>
			  <tr>
				<td colspan="5"><?="Data not available"?></td>
			  </tr>			
			<?php
		}
	}
	
	
	}
