<?php 
if (! defined('BASEPATH')) 
{
	exit('No direct script access allowed');
}
class Purchase_data_fetch_model extends CI_Model
{
	public function fetch_store_name_asDropDown($location_type=0,$dept_type=0)
	{
		$this->db->select('*');
		$this->db->from('master_store');
		if($location_type!=0)
			$this->db->where('location_type', $location_type);
		if($dept_type!=0)
			$this->db->where('department_type', $dept_type);		
		$query = $this->db->get();
		$options = array();
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['store_name'];
		}
		return $options;		
	}
	public function fetch_department_name_asDropDown($active_flag=0,$dept_type=0)
	{
		$this->db->select('*');
		$this->db->from('employee_department');
		if($active_flag!=0)
			$this->db->where('active_flag', $active_flag);
		if($dept_type!=0)
			$this->db->where('department_type', $dept_type);		
		$query = $this->db->get();
		$options = array();
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['department_name'];
		}
		return $options;		
	}
	public function fetch_pharmacy_indent_order($to_date,$from_date,$location_uid,$indent_type)
	{
		
		$this->db->select('ind.*, sm.store_name');
		$this->db->from('inventory_indent ind');
		$this->db->join('master_store sm', 'sm.uid=ind.location_uid_to');
		$this->db->where('ind.indent_date>=',$from_date);
		$this->db->where('ind.indent_date<=',$to_date);		
			//$this->db->where('ind.location_uid_to',$location_uid);
		$this->db->where('ind.location_uid_from',$location_uid);
			
		$query = $this->db->get();
		return $query->result();//passing all result to controller		
		
	}
		public function fetch_pharmacy_name($pharmacy_uid)
	{
		$qry="SELECT * FROM `master_clinic` WHERE `uid` = '$pharmacy_uid'    ";
		
		$query=$this->db->query($qry);
		return $query->result();
	}
	public function fetch_store_name($store_uid)
	{
		$this->db->select('*');
		$this->db->from('master_store');		
		$this->db->where('uid',$store_uid);		
		$query=$this->db->get();
		return $query->row();
	}
	public function fetch_indent_order_details($indent_id)
	{
		$qry="SELECT id.*,sm.uid as store_id,sm.store_name FROM inventory_indent_details id,master_store sm WHERE id.location_uid_from=sm.uid and `indent_uid` = '$indent_id' ";
		
		$query=$this->db->query($qry);
		return $query->result();
	}
	public function fetch_item_name($item_uid)
	{
		
			$qry="SELECT * FROM `master_item` WHERE `uid` = '$item_uid' ";
		
		$query=$this->db->query($qry);
		return $query->row();
	}
	public function fetch_unit_name($indent_unit_uid)
	{
		$qry="SELECT * FROM `master_misc_hims` WHERE `uid` = '$indent_unit_uid' ";
		
		$query=$this->db->query($qry);
		return $query->result();
	}
public function fetch_medicine_by_name($item_name)
	{
		$this->db->select('uid,item_name,gst_rate,hsn_code,uom');
		$this->db->from('master_item');
		$this->db->like('item_name', $item_name); 
		$this->db->order_by('item_name');
		$query = $this->db->get();
		return $query->result();		
	}
	public function fetch_all_medicine_name_list()	
	{
		$this->db->select('uid,item_name,form,madeby,strength,schedule,hsn_code,gst_rate,uom');
		$this->db->from('master_item');
		$this->db->where('active_flag','1');
		$this->db->order_by('item_name','ASC');
		$query = $this->db->get();
		return $query->result();//passing all result to controller		
	}
	function fetch_approved_indent_list($date,$date_to="",$location="")
	{
		$this->db->select('si.*,sm.store_name');
		$this->db->from('inventory_stock_issue si');
		$this->db->join('master_store sm', 'sm.uid=si.location_uid_from');		
		if($date_to=="")
			$this->db->where('doi',$date);
		else
		{
			$this->db->where('doi>=',$date);
			$this->db->where('doi<=',$date_to);
		}
		//$this->db->where('location_uid_from',$location);
		//$this->db->where('is_goodsReceived','0');
		$this->db->where('location_uid_to',$location);
		$query = $this->db->get();
		return $query->result();//passing all result to controller			
	}
	function fetch_indent_issue_list($issue_id)
	{
		$this->db->select('si.*,sm.store_name,m.misc_name');
		$this->db->from('inventory_stock_issue_details si');
		$this->db->join('master_store sm', 'sm.uid=si.location_uid_from');
		$this->db->join('master_misc_hims m', 'm.uid=si.unit_uid');
		
		$this->db->where('si.issue_uid',$issue_id);
		
		$query = $this->db->get();
		return $query->result();//passing all result to controller			
	}
	public function fetch_medicine_record($medicine_id)
	{ 
		$this->db->select('*');
		$this->db->from('master_item');
		$this->db->where('uid', $medicine_id);
		$query=$this->db->get();
		return $query->row();		
	}
	function fetch_opening_stock($item_uid,$batch_no="")
	{
		$this->db->select_sum('quantity');
		$this->db->from('inventory_purchase_details');
		$this->db->where('purchase_uid',11);
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}
		$this->db->where('item_uid',$item_uid);
		$query = $this->db->get();
		return $query->row();//passing all result to controller			
	}
	function fetch_item_total_entry($item_uid,$batch_no="")
	{
		$this->db->select('sum(quantity) as tot_qty');
		$this->db->from('inventory_purchase_details');
		$this->db->where('purchase_uid!=',11);
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}		
		$this->db->where('item_uid',$item_uid);
		$query = $this->db->get();
		return $query->row();//passing all result to controller			
	}
function fetch_free_item_total_entry($item_uid,$batch_no="")
	{
		$this->db->select('sum(free_quantity) as tot_freeqty');
		$this->db->from('inventory_purchase_details');
		$this->db->where('purchase_uid!=',11);
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}		
		$this->db->where('item_uid',$item_uid);
		$query = $this->db->get();
		return $query->row();//passing all result to controller			
	}	
	function fetch_item_total_issue($item_uid,$batch_no="")
	{
		$this->db->select('sum(quantity) as tot_issue_qty');
		$this->db->from('inventory_stock_issue_details');
		$this->db->where('item_uid',$item_uid);
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}		
		$query = $this->db->get();
		return $query->row();//passing all result to controller			
	}
function fetch_uom_name($uom_id)
	{
		$this->db->select('*');
		$this->db->from('master_misc_hims');
		$this->db->where('uid', $uom_id);
		$query=$this->db->get();
		return $query->row();	
	}
	public function fetch_all_medicine_closing_name_list($searchTxt="")	
	{
		$this->db->select('uid,item_name,form,madeby,strength,schedule,hsn_code,gst_rate,uom');
		$this->db->from('master_item');
		if($searchTxt!="")
			$this->db->like('item_name',$searchTxt);
		$this->db->where('active_flag','1');
		$this->db->where('show_pharmacy','1');
		$this->db->order_by('item_name','ASC');
		$query = $this->db->get();
		return $query->result();//passing all result to controller		
	}
		public function fetch_inventory_distinct_batch_by_item($item_id,$location_id)
	{
		$qry="SELECT distinct(batch_no),item_uid,batch_no,expiry FROM `inventory_stock_issue_details` WHERE `item_uid` = '$item_id'  and is_goodsReceived='1'  and location_uid_to='$location_id'";
		
		$query=$this->db->query($qry);
		return $query->result();
	}
	public function fetch_inventory_item_batch_quantity($item_id,$batch_no,$table,$location_uid_from=0,$freeQuantityCountFlag=0)
	{  
		if($freeQuantityCountFlag==0)
			$this->db->select('sum(quantity) as total_batch_quantity');
		else if($freeQuantityCountFlag==1)
			$this->db->select('sum(quantity) as total_batch_quantity,sum(free_quantity) as total_batch_free_quantity');
		$this->db->from($table);
		$this->db->where('item_uid', $item_id);
		$this->db->where('batch_no', $batch_no);
		if($location_uid_from!=0)
		{
			$this->db->where('location_uid_to', $location_uid_from);
		}
		$query=$this->db->get();
		return $query->row();		
	}
	function fetch_item_total_issueReceived($item_uid,$batch_no="",$location_uid="")
	{
		$this->db->select('sum(quantity) as tot_qty');
		$this->db->from('inventory_stock_issue_details');
		$this->db->where('is_goodsReceived','1');
		if($batch_no!="")
		{
			$this->db->where('batch_no',$batch_no);
		}
		if($location_uid!="")
		{
			$this->db->where('location_uid_to',$location_uid);
		}		
		$this->db->where('item_uid',$item_uid);
		$query = $this->db->get();
		return $query->row();//passing all result to controller			
	}
	public function fetch_item_batch_quantity($item_id,$batch_no)
	{  
		$this->db->select('sum(quantity) as total_batch_quantity');
		$this->db->from('inventory_stock_issue_details');
		$this->db->where('item_uid', $item_id);
		$this->db->where('batch_no', $batch_no);
		$this->db->where('location_uid_to', $_SESSION['sessionLocationInfo']['locationId']);
		//$this->db->group_by('batch_no', $batch_no);
		$query=$this->db->get();
		return $query->row();		
	}
	public function fetch_sales_item_quantity($item_id,$batch_no)
	{  
		$this->db->select('sum(quantity) as total_sales_quantity');
		$this->db->from('inventory_pahmacy_sale_details');
		$this->db->where('item_uid', $item_id);
		$this->db->where('batch_no', $batch_no);		
		$query=$this->db->get();
		return $query->row();		
	}
	public function fetch_batch_by_qty($batch_no)
	{ 
		$this->db->select('inviss.uid,inviss.expiry,inviss.quantity,inviss.tax_rate,inviss.mrp,inviss.unit_uid,inviss.pack,mis.misc_name');
		$this->db->from('inventory_stock_issue_details inviss');
		$this->db->join('master_misc_hims mis', 'mis.uid=inviss.unit_uid');
		$this->db->where('inviss.batch_no', $batch_no);
		$query=$this->db->get();
		return $query->row();		
	}
	public function fetch_patient_name($item_name)
	{
		$this->db->select('uid,mobile,full_name,gender,address1,city,pin');
		$this->db->from('patient');
		$this->db->like('mobile', $item_name); 
		$this->db->order_by('mobile');
		$query = $this->db->get();
		return $query->result();		
	}
	public function fetch_doctor_name($item_name)
	{
		$this->db->select('*');
		$this->db->from('reffered_doctor');
		$this->db->like('doctor_name', $item_name); 
		$this->db->order_by('doctor_name');
		$query = $this->db->get();
		return $query->result();		
	}
	
	public function fetch_patient_invoice_details($sale_invoice_uid)
	{ 
		$this->db->select('*');
		$this->db->from('inventory_pharmacy_sales');
		$this->db->where('uid', $sale_invoice_uid);
		$query=$this->db->get();
		return $query->row();		
	}
	function fetch_item_id_by_invoice_no($sale_invoice_uid)
	{
		$this->db->select('si.*,med.item_name,med.hsn_code,med.madeby');
		$this->db->from('inventory_pahmacy_sale_details si');
		$this->db->join('master_item med', 'med.uid=si.item_uid');		
		
		$this->db->where('si.sale_uid',$sale_invoice_uid);		
		$query = $this->db->get();
		return $query->result();//passing all result to controller			
	}
	
	public function fetch_patient_using_search_filter($pid,$pname_txt,$mobile)
	{
		$this->db->select('*');
		$this->db->from('patient');
		if($pid!="")
			$this->db->where('uid', $pid);
		if($pname_txt!="")
			$this->db->like('full_name', $pname_txt);
		if($mobile!="")
			$this->db->like('mobile', $mobile);
		$query=$this->db->get();
		return $query->result();
	}
	public function fetch_supplier_by_name($supplier)
	{
		$this->db->select('*');
		$this->db->from('master_ledger');
		if($supplier!='ALL' && $supplier!='all')
			$this->db->like('ledger_name', $supplier);
$this->db->where('ledger_group',10);
$this->db->or_where('ledger_group',9);		
		$this->db->order_by('ledger_name');
		$query = $this->db->get();
		return $query->result();		
	}

	public function fetch_supplier_record($record_id)
	{
		$this->db->select('*');
		$this->db->from('master_ledger');
		$this->db->where('uid',$record_id);
		$query = $this->db->get();
		return $query->row();		
	}
	public function fetch_name_by_id($id,$table,$fieldName)
	{
		$this->db->select($fieldName);
		$this->db->from($table);
		$this->db->where('uid',$id);
		$query = $this->db->get();
		return $query->row()->$fieldName;
	}
	public function fetch_po_requisition_list($from_date,$to_date,$location_uid)
	{
		$this->db->select('pr.*,im.item_name,im.uom');
		$this->db->from('inventory_purchase_requisition pr');
		$this->db->join('master_item im', 'im.uid=pr.item_uid');
		
					
			if($location_uid!="-1")
			{
					$this->db->where('pr.pr_date>=',$from_date);
						$this->db->where('pr.pr_date<=',$to_date);
					
					$this->db->where('location_uid_to',$location_uid);
			}
			else
					{
						$this->db->where('pr.pr_date>=',$from_date);
						$this->db->where('pr.pr_date<=',$to_date);
					}
					$this->db->where('authorize',1);
					
					$query = $this->db->get();
					//print_r($this->db->last_query()); die(0);
					
					return $query->result();//passing all result to controller
	    }
	
	public function fetch_medicine_by_po($item_name)
	{
		$this->db->select('im.uid,im.item_name,im.gst_rate,im.hsn_code,im.uom,im.item_category,mis.misc_name');
		$this->db->from('master_item im');
		$this->db->join('master_misc_hims mis', 'mis.uid=im.uom');
		$this->db->like('item_name', $item_name); 
		$this->db->order_by('item_name');
		$query = $this->db->get();
		return $query->result();		
	}
	function fetch_invoice_no($invoice_no)
	{
		$this->db->select('*');
		$this->db->from('inventory_po');
			
		$this->db->where('invoice_no',$invoice_no);
		$query = $this->db->get();
		return $query->result();//passing all result to controller			
	}
	public function fetch_po_register_list($from_date,$to_date,$supplier_uid)
	{
		
		$this->db->select('invp.*, sm.store_name, Supp.ledger_name');
		$this->db->from('inventory_po invp');
		$this->db->join('master_store sm', 'sm.uid=invp.store_uid');
		$this->db->join('master_ledger Supp', 'Supp.uid=invp.supplier_uid');
		$this->db->where('invp.invoice_date>=',$from_date);
		$this->db->where('invp.invoice_date<=',$to_date);		
			if($supplier_uid!="")
		$this->db->where('invp.supplier_uid',$supplier_uid);
			
		$query = $this->db->get();
		return $query->result();//passing all result to controller		
		
	}
	
	function fetch_p_requisition_list($from_date,$to_date)
	{
		$this->db->select('si.*,med.item_name');
		$this->db->from('inventory_purchase_requisition si');
		$this->db->join('master_item med', 'med.uid=si.item_uid');		
		$this->db->where('si.entry_date_time>=',$from_date);
		$this->db->where('si.entry_date_time<=',$to_date);
		$this->db->where('si.isProcesed',0);
		$this->db->order_by("uid", "desc");
		$query = $this->db->get();
		return $query->result();//passing all result to controller			
	}
	public function fetch_pr_process_list($from_date,$to_date,$supplier_uid)
	{
		
		$this->db->select('invp.*, sm.store_name, Supp.ledger_name,med.item_name,med.uom');
		$this->db->from('inventory_purchase_requisition invp');
		$this->db->join('master_store sm', 'sm.uid=invp.supplier_to');
		$this->db->join('master_ledger Supp', 'Supp.uid=invp.supplier_uid');
		$this->db->join('master_item med', 'med.uid=invp.item_uid');
		$this->db->where('invp.process_date>=',$from_date);
		$this->db->where('invp.process_date<=',$to_date);
$this->db->where('invp.isProcesed',1);		
			if($supplier_uid!="")
		$this->db->where('invp.supplier_uid',$supplier_uid);
			
		$query = $this->db->get();
		//print_r($this->db->last_query()); die(0);
		return $query->result();//passing all result to controller		
		
	}
	public function fetch_misc_dropDown($tag)
	{
		$qry="select uid,misc_name,tag from master_misc_hims where tag=$tag";
		$query=$this->db->query($qry);
		$options = array();
		$options ['-1'] = "-- Select Name --";
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['misc_name'];
		}
		return $options;		
	}
	public function fetch_medicine_record_by_id($medicine_id,$type="")
	{ 
		//if($type==1)
			$this->db->select('itm.*, sc.composition');
		//else if($type==2)
			//$this->db->select('itm.*');
		$this->db->from('master_item itm');
		//if($type==1)
			$this->db->join('master_salt_composition sc', 'sc.uid=itm.composition_uid');
	
		$this->db->where('itm.uid', $medicine_id);
		$query=$this->db->get();
		return $query->row();		
	}
	public function fetch_composition_list($text)	
	{
		$this->db->select('*');
		$this->db->from('master_salt_composition');
		$this->db->like('composition', $text);
		$query=$this->db->get();
		return $query->result();
	}
	public function update_item_by_name($item_name)
	{
		$this->db->select('im.uid,im.item_name,im.gst_rate,im.hsn_code,im.uom,im.item_category,mis.misc_name');
		$this->db->from('master_item im');
		$this->db->join('master_misc_hims mis', 'mis.uid=im.uom');
		$this->db->like('item_name', $item_name,'both'); 
		$this->db->order_by('item_name');
		$query = $this->db->get();
		return $query->result();		
	}
	public function fetch_company_by_name($item_name)
	{
		$this->db->select('uid,misc_name');
		$this->db->from('master_misc_hims');
		$this->db->like('misc_name', $item_name); 
		$this->db->where('tag',119);
		$this->db->order_by('misc_name');
		$query = $this->db->get();
		return $query->result();		
	}
	public function fetch_medicine_list_by_name($text="",$search_by)	
	{
		$this->db->select('*');
		$this->db->from('master_item');
		if($text!="")
			$this->db->like('item_name', $text);
		if($search_by>0)
			$this->db->where('item_category', $search_by);
		$this->db->order_by('uid','DESC');
		$query=$this->db->get();
		return $query->result();		
	}
	public function fetch_item_by_name_and_category($text="",$category)	
	{
		$this->db->select('*');
		$this->db->from('master_item');
		if($text!="")
			$this->db->like('item_name', $text);
		if($category>0)
			$this->db->where('item_category', $category);
		$this->db->order_by('uid','DESC');
		$query=$this->db->get();
		return $query->result();		
	}	
	
	public function fetch_item_by_category($item_category)
	{ 
		$this->db->select('uid');
		$this->db->from('master_item');
		$this->db->where('item_category', $item_category);
		$query=$this->db->get();
		return $query->result();		
	}
	public function fetch_itemMaping()
	{
		$this->db->select('med_map.*, sm.department_name, med.item_name');
		$this->db->from('item_mapping med_map');
		$this->db->join('employee_department sm', 'sm.uid=med_map.department_uid');
		$this->db->join('master_item med', 'med.uid=med_map.item_uid');
		$query = $this->db->get();
		return $query->result();//passing all result to controller		
		
	}
	public function check_item_mapping_exists($tableName,$item_uid,$store_uid)
	{
		 $qry="SELECT * FROM $tableName WHERE item_uid='$item_uid' AND department_uid= '$store_uid'";

		//echo $qry; exit();
		
		$query=$this->db->query($qry);
		$result=$query->result_array();	

		if(!empty($result))
		{
			return true;
		}

		else
		{
			return false;
		}
	}
	
	function item_mapping_delete_record($tableName,$item_uid,$store_uid)
		{
			$this->db->where('item_uid',$item_uid);
			$this->db->where('department_uid',$store_uid);			
			$result=$this->db->delete($tableName);
		}
		public function fetch_composition_by_name($composition_name)
	{
		$this->db->select('uid,composition');
		$this->db->from('master_salt_composition');
		$this->db->like('composition', $composition_name); 
		$this->db->order_by('composition');
		$query = $this->db->get();
		return $query->result();		
	}
	public function get_all_supplier_by_pr($supplier_uid)
	{
		
		$this->db->select('*');
		$this->db->from('inventory_purchase_requisition');		
		$this->db->where('supplier_uid',$supplier_uid);
		$this->db->where('isProcesed',1);
		$this->db->where('poProcesed',0);
$this->db->group_by('supplier_requisition_uid');		
		$query = $this->db->get();
		return $query->result();//passing all result to controller		
		
	}
	function fetch_all_supplier_by_po($uid)
	{
		 $qry="SELECT pod.*, im.item_name, im.uom,im.hsn_code,im.gst_rate, mic.misc_name FROM inventory_purchase_requisition pod, master_item im, master_misc_hims mic WHERE  pod.item_uid=im.uid and im.uom=mic.uid and `supplier_requisition_uid` = '$uid' and `isProcesed` = '1'";
		
		$query=$this->db->query($qry);
		return $query->result();
	}
	function fetch_search_supplier_list($search_type="")
	{		
		$this->db->select('*');
		$this->db->from('master_ledger');
		$this->db->where('ledger_group',10);
		if($search_type!="")
		{
			$this->db->where('status_flag',$search_type);
		}
	
		$query = $this->db->get();
		//print_r($this->db->last_query());
		return $query->result();
	}

}