<?php
	defined('BASEPATH') OR exit('No direct script access allowed');
	class Login extends MX_Controller
	{
		public function __construct()
		{
			parent::__construct();
			$this->load->model('Login_model'); 
			$this->load->helper('utility');
			$this->load->model('Common/Common_data_fetch_model');
		}
		//===================================================================
		function index()
		{
			$data = array();
			$data['all_clinic']=$this->Common_data_fetch_model->fetch_clinic();
			$this->load->view('index',$data);
		}
		public function loginAuth()//module login authorization check
		{
			
			$this->load->helper(array('form', 'url'));
			$this->load->library('form_validation');
			$this->form_validation->set_error_delimiters('<span style="color:red">', '</span>');
			$this->form_validation->set_rules('user_id', 'User Mobile', 'required|numeric');
			$this->form_validation->set_rules('pwd', 'User Password', 'required');

			if($this->form_validation->run()!= FALSE)
			{		
				//input login form data from the login page
				$username=$this->input->post("user_id");
				$password=$this->input->post("pwd");
				$clinic_id=$this->input->post("clinic");

//,$all_access_flag,$allClinicAccessResult

				$authenticationResult=$this->Login_model->loginAuthentication($username,$password,$clinic_id);//receiving login authentication data

				if(!empty($authenticationResult))//user available
				{				
				$clinic_data=$this->Login_model->fetch_clinic_details($clinic_id);
					//set session value when successfully logged in_array
					$loginfo = array(
					   'userLoggedin'  => TRUE,
					   'loggedUserId'  =>  $authenticationResult[0]['uid'],
					   'fullname'	=> $authenticationResult[0]['full_name'],
					   'desig'	=> $authenticationResult[0]['designation'],
					   'clinicId'	=> $clinic_id,
					   'clinic_info'	=> $clinic_data->clinic_code,
					   'clinic_name'	=> $clinic_data->clinic_name
					);
					$this->session->set_userdata('pab_sessionLogInfo',$loginfo);

					redirect(base_url('sales/dashboard'));
				}
				else
				{
					//$this->session->set_flashdata('error','Record Not Found');
					redirect(base_url('login'));
				}
			
			}
			else
			{
				redirect(base_url('login'));
			}	
		}

		function logout()
		{					
			$this->session->sess_destroy();
			redirect(base_url());
		}			
	}

	

?>