<?php 
if (! defined('BASEPATH')) 
{
	exit('No direct script access allowed');
}
class Common_data_fetch_model extends CI_Model
{
	public function fetch_state()
	{
		$qry="SELECT `uid`, `statedist_name` FROM `master_state_dist` WHERE state_tag=0 ORDER BY `statedist_name`";
		$query=$this->db->query($qry);
		$options = array();
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['statedist_name'];
		}
		return $options;
	}
	public function fetch_district($stateId)
	{
		$qry="select uid,statedist_name from master_state_dist where state_tag=$stateId order by statedist_name";
		$query=$this->db->query($qry);
		$options = array();
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['statedist_name'];
		}
		return $options;
	}
	public function fetch_country()
	{
		$qry="SELECT uid, country_name FROM `master_country` ORDER BY `country_name`";
		$query=$this->db->query($qry);
		$options = array();
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['country_name'];
		}
		return $options;
	}
	function fetch_misc_details_dropdown($tag)
	{
	  $this->db->select('*');
	  $this->db->from('master_misc');
      $this->db->where('tag',$tag);
	  $this->db->order_by('misc_name','ASC');
      $query = $this->db->get();
		$options = array();
		$options ["-1"] = "-- Select --";
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['misc_name'];
		}
		return $options;
	}
	public function fetch_clinic()
	{
		$qry="SELECT `uid`, `clinic_code` FROM `master_clinic` WHERE active_flag=1 and category<2 ORDER BY `uid`";
		$query=$this->db->query($qry);
		$options = array();
		$options ["-1"] = "-- Select --";
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['clinic_code'];
		}
		return $options;
	}
	public function fetch_buildingDD()
	{
		$qry="SELECT `uid`, `clinic_code` FROM `master_clinic` WHERE active_flag=1 and category=2 ORDER BY `uid`";
		$query=$this->db->query($qry);
		$options = array();
		$options ["-1"] = "-- Select --";
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['clinic_code'];
		}
		return $options;
	}	
	function fetch_department_dropdown($deptType=0)
	{
	  $this->db->select('*');
	  $this->db->from('employee_department');
		if($deptType!=0)
		{	
			$this->db->where('department_type',$deptType);
			$this->db->where('uid >',1);
		}
		else
		{
			$this->db->where('uid >',1);
		}
		$query = $this->db->get();
		$options = array();
		$options ["-1"] = "-- Select --";
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['department_name'];
		}
		return $options;
	}
	public function autoID_flag_check($check_value,$clinic_uid)	
	{
		$this->db->select('uid,autoid_condition,issetFlag');
		$this->db->from('settings_auto_id');
		$this->db->where('autoid_condition',$check_value);
		$this->db->where('clinic_uid',$clinic_uid);
		$query=$this->db->get();
		return $query->row();		
	}	
	public function fetch_store($location_type=0,$department_type=0)
	{
		$this->db->select('*');
		$this->db->from('master_store');
		if($location_type!=0)
			$this->db->where('location_type',$location_type);
			$this->db->where('department_type',$department_type);
		$query = $this->db->get();		

		$options = array();
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['store_name'];
		}
		return $options;
	}
	function fetch_salt_record($salt_uid)
	{
		$this->db->select('*');
		$this->db->from('master_salt_composition');
		$this->db->where('uid', $salt_uid);
		$query=$this->db->get();
		return $query->row();	
	}
	/////***************************** pronobesh ****************
	public function fetch_clinic_array()
	{
		$qry="SELECT * FROM `master_clinic` WHERE active_flag=1 ORDER BY `uid`";
		$query=$this->db->query($qry);
		// $options = array();
		// $options ["-1"] = "-- Select --";
		// foreach($query->result_array() as $row)
		// {
		//    $options [$row['uid']] = $row['clinic_code'];
		// }
		return $query->result_array();
	}
	public function fetch_clinic_array_new()
	{
		$qry="SELECT `uid`, `clinic_code` FROM `master_clinic` WHERE active_flag=1 and category<2 ORDER BY `uid`";
		$query=$this->db->query($qry);
		// $options = array();
		// $options ["-1"] = "-- Select --";
		// foreach($query->result_array() as $row)
		// {
		//    $options [$row['uid']] = $row['clinic_code'];
		// }
		return $query->result_array();
	}
	public function getdoctorbydepartment($department)
	{
		$qry="SELECT full_name,uid FROM `employee` WHERE employee_type=4 AND department_uid=".$department."";
		$query=$this->db->query($qry);
		return $query->result_array();
	}
	public function getdoctorbyspeciality($speciality)
	{
		$qry="SELECT full_name,uid FROM `employee` WHERE employee_type=4 AND speciality=".$speciality."";
		$query=$this->db->query($qry);
		return $query->result_array();
	}	
	// ************************** end pronobesh *****************
//------------------stock block------------------------
	public function fetch_indent_order_list($to_date,$from_date,$store_uid,$indent_type,$location_from_uid,$indent_no)
	{
		$this->db->select('ind.*, sm.store_name');
		$this->db->from('inventory_indent ind');
		$this->db->join('master_store sm', 'sm.uid=ind.location_uid_to');
		if($indent_no!="")
		{
			$this->db->where('ind.uid', $indent_no);
		}
		else
		{
		$this->db->where('ind.indent_date>=', $from_date); 
		$this->db->where('ind.indent_date<=', $to_date);
		}
		
		$this->db->where('ind.location_uid_from',$location_from_uid);
			$this->db->where('ind.location_uid_to',$store_uid);

		$query = $this->db->get();
		return $query->result();		
	}
	public function fetch_store_name($store_uid)
	{
		$this->db->select('*');
		$this->db->from('master_store');		
		$this->db->where('uid',$store_uid);		
		$query=$this->db->get();
		return $query->row();
	}
	public function fetch_indent_details_list($indent_uid)
	{		
		$this->db->select('ind.*,itm.item_name,i.indent_date, sm.store_name');
		$this->db->from('inventory_indent_details ind');
		$this->db->join('inventory_indent i','ind.indent_uid=i.uid');
		$this->db->join('master_store sm', 'sm.uid=ind.location_uid_to');
		$this->db->join('master_item itm','itm.uid=ind.item_uid');
		
			$this->db->where('ind.indent_uid',$indent_uid);
			
		$query = $this->db->get();
		return $query->result();//passing all result to controller		
		
	}
	
		function fetch_all_modules($service_relationship_uid=0)
	{
	  $this->db->select('*');
	  $this->db->from('master_misc');
      $this->db->where('tag',101);
      $this->db->where('service_relationship_uid',$service_relationship_uid);
      $this->db->where('active_flag',1);
	  $this->db->order_by("module_relationship", "asc");
	  $this->db->order_by("misc_name", "asc");
      $query = $this->db->get();
      
	  return $query->result();
	}
	
	public function fetch_item_by_name($item_name,$category=0)
	{
		$this->db->select('uid,item_name,gst_rate,hsn_code,uom,composition_uid');
		$this->db->from('master_item');
		if($category>0)
			$this->db->where('item_category',$category);
		$this->db->like('item_name', $item_name); 
		$this->db->order_by('item_name');
		$query = $this->db->get();
		return $query->result();		
	}
	


//------------------stock block------------------------
	function fetch_master_record($table,$select_fields_string,$search_filed,$search_field_value,$is_like_search=0,$is_return_type_row=1)
	{
		$this->db->select($select_fields_string);
		$this->db->from($table);
		if($search_field_value!="%")
		{	
			if($is_like_search==1)
				$this->db->like($search_filed,$search_field_value,'both');
			else
				$this->db->where($search_filed, $search_field_value); 
		}
		$query = $this->db->get();	
		
		if($is_return_type_row==1)
		{
			return $query->row();
		}
		else
		{
			return $query->result();
		}	
	}
	public function fetch_data_with_multiple_condition($table,$select_fields_string,$search_filed,$search_field_value,$is_like_search=0,$is_return_type_row=1,$condition_data_array,$where_condition=0)
	{			
		$this->db->select($select_fields_string);
		$this->db->from($table);
		if($search_field_value!="%")
		{	
			if($is_like_search==1)
				
				$this->db->like($search_filed,$search_field_value,'both');
			
			//else
				//$this->db->where($condition_data_array); 
			
		}
		if($where_condition==1)
				$this->db->where($condition_data_array);
		$query = $this->db->get();
	//echo $this->db->last_query(); exit();		
		if($is_return_type_row==1)
		{
			return $query->row();
		}
		else
		{
			return $query->result();
		}
	
		
	}

}