<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Common extends MX_Controller 
{

	public function __construct()
	{
		parent::__construct();
			$this->load->model('Common_data_fetch_model'); 
			$this->load->model('Common_data_add_model');
			$this->load->library(array('parser'));			
	}
	function delete_list_items($record_id,$table_name,$condition_field,$redirect_url)
	{
		$data=$this->Common_data_add_model->delete_record($table_name,$condition_field,base64_decode($record_id));		
		$url=base64_decode($redirect_url);
		redirect(base_url().$url);
	}	
	function change_password()
	{
		$old_password=$this->input->post('old_password');
		$new_password=$this->input->post('new_password');
		$data = array(
			'password' => $new_password    
			);
		$conditions = array(
		'password' => $old_password,
		'uid' => $_SESSION['sessionLogInfo']['loggedUserId']
		)	;
		
		$this->Common_data_add_model->update_data_with_multiple_condition($data,'employee',$conditions);
		$this->session->set_flashdata('success', 'Data Saved...');	
		redirect(base_url()."login/logout");
	}
	function load_district()
	{
		$state_id=$this->input->post("state_id");
		$district=$this->Common_data_fetch_model->fetch_district($state_id);
		foreach($district as $key => $key_value)
		{
			?>
			<option value="<?=$key?>"><?=$key_value?></option>
			<?php			
		}		
	}


//---------stock block-----------------
	function get_indent_order_details_list()
	{
		
		$to_date=date('Y-m-d',strtotime($this->input->post('to_date')));
		$from_date=date('Y-m-d',strtotime($this->input->post('from_date')));
		$location_from_uid=7;
		$store_uid=$this->input->post('store_uid');
		$indent_type='1';
		$indent_no=$this->input->post('indent_no');
		$data=$this->Common_data_fetch_model->fetch_indent_order_list($to_date,$from_date,$store_uid,$indent_type,$location_from_uid,$indent_no);
		$k=0;
		$oldIndent=0;
		$newIndent=0;
		$noOfIndent=0;
		$color=2;		
		foreach($data as $record)
		{
		    
			$k++;
			$response1=$this->Common_data_fetch_model->fetch_store_name($record->location_uid_to);
		
			
			switch($record->status)
			{
				case 0:
					$statusTxt="Pending";
					break;
				case 1:
					$statusTxt="Processing";
					break;
				case 2:
					$statusTxt="Completed";
					break;					
									
			}
			  $newIndent = $record->indent_uid;
			 
				if ($newIndent >$oldIndent && $color==2)
					{
					++$noOfIndent;
					$color = 3;
					}
					else if ($newIndent >$oldIndent && $color==3)
					{
					++$noOfIndent;	
					$color = 2;
					} 	
					else
					{
						
					}		
					$oldIndent = $newIndent;
			
				
			
					?>
				<tr>
  <td><?php echo $k;?></td>
  <td  ><?php echo $record->uid;?><a  data-toggle="collapse" data-target="#demo<?php echo $k;?>" class="accordion-toggle cursor-pointer  btn custom_button" style="cursor: pointer;height: auto;
  margin-left: 5px;">Details</a></td>
  <td><?php echo $record->store_name; ?></td>
  <td><?php echo $record->indent_date;?></td>
  <td><?php if($record->priority==1){?>
    Low
    <?php }if($record->priority==2){?>
    Medium
    <?php }if($record->priority==3){?>
    High
    <?php }?></td>
	
	<?php
	if($record->item_category==1)
		$item_category_text="Medicine";
	else if($record->item_category==2)
		$item_category_text="Stationaries";
	else if($record->item_category==3)
		$item_category_text="Consumables";
	else if($record->item_category==4)
		$item_category_text="Reagent";
	else
		$item_category_text="";
	?>
  <td><?php echo $item_category_text;?></td>
  <td><?php echo $record->remarks;?></td>
</tr>
<tr>
  <td  colspan="6" class="hiddenRow"><div class="accordian-body collapse" id="demo<?php echo $k;?>">
      <table class="table hidden_table" >
        <tr class="">
            <td>Item</td>
            <td>Quantity</td>
            <td>Uom</td>
			<td>Status</td>
          </tr>
        <tbody>
		<?php
		$indent_uid=$record->uid;
		$data=$this->Common_data_fetch_model->fetch_indent_details_list($indent_uid);
		foreach($data as $record)
		{
			switch($record->status)
			{
				case 0:
					$statusTxt="Pending";
					break;
				case 1:
					$statusTxt="Processing";
					break;
				case 2:
					$statusTxt="Completed";
					break;					
									
			}
		?>
		
          <tr>
            <td><?php echo $record->item_name;?></td>
            <td><?php echo $record->indent_quantity;?></td>
            <td><?=get_misc_text($record->indent_unit_uid)?> </td>
           <td><?=$statusTxt;?></td>
          </tr>
		  <?php 
		}
		  ?>
          
        </tbody>
      </table>
    </div></td>
</tr>
			<?php
		}
		?>
		<!--<tr>
			<td colspan="8" class="text-align:left">
				<span class="badge badge-danger" style="color: #fff;
					background-color: #dc3545;">Total Indent:<span class="badge badge-light" id="total_indent"><?=$noOfIndent?></span>
				</span>
			</td>
		</tr>-->
		<?php	
		//log entry pass
		if($this->input->post('page_uid'))
		$page_uid=$this->input->post('page_uid');
		else
		$page_uid=1;
		$activity='Indent Search';
		log_entry($_SESSION['sessionLogInfo']['loggedUserId'],$page_uid,$activity_id=4,$activity);		
	}
	function search_item_by_name()
	{
		$item_name=$this->input->post('search_text');
		$list_id=$this->input->post('list_id');
		$field_id=$this->input->post('field_id');
		$category=$this->input->post('category');
		$row_id=$this->input->post('row_id');
		
		
		$data=$this->Common_data_fetch_model->fetch_item_by_name($item_name,$category);		
		foreach($data as $record)
		{
		?>
			<li><a class="dropdown-item" href="javascript:void(0)" onclick="item_set_record('<?=base64_encode($record->uid)?>','<?=$record->item_name?>','<?=$list_id?>','<?=$field_id?>','<?=$row_id?>','<?=$record->uom?>')"><?=$record->item_name?></a></li>			
		<?php
			
		}//end of foreach
				
	}
	function get_main_store_stock($return_flag=0)
	{
		$item_uid=base64_decode($this->input->post('enc_item_id'));
		$location_uid=$this->input->post('location_uid');			
		$this->load->library('CustomInventoryLib');
		$myLib = new CustomInventoryLib();
		//get counter stock
		$StoreStock=$myLib->getStoreStock($item_uid,$batch_no="",$location_uid,$return_flag=0);
		echo $StoreStock;
	}
	function get_counter_stock($return_stat='0',$itemUid=0,$location_uid=0)
	{
		if($itemUid==0 && ($this->input->post('enc_item_id')))
			$item_uid=base64_decode($this->input->post('enc_item_id'));		
		else
			$item_uid=$itemUid;
		if($location_uid==0 && ($this->input->post('location_uid')))
			$location_uid=$this->input->post('location_uid');	
		else
			$location_uid=$location_uid;
		$this->load->library('CustomInventoryLib');
		$myLib = new CustomInventoryLib();
		//get counter stock
		$currentCounterStock=$myLib->getLocationStock($item_uid,$return_flag=1,$batch_no="",$location_uid,$location_type=1);//return required			
//$totalSale=$this->Pharmacy_data_fetch_model->fetch_item_total_sale($item_uid);
		if($return_stat=="0")
		{
			echo $currentCounterStock ;
		}
		else
		{
			return $currentCounterStock ;
		}
	}
	function indent_save()
	{
		$uid=$this->input->post('uid'); 
	    if($uid=="0")//save
		{
		   	$no_indent_row=count($this->input->post('item_uid'));
			
			$item_uid_array=$this->input->post('item_uid');
			$indent_quantity_array=$this->input->post('quantity');
			$indent_unit_uid_array=$this->input->post('unit_uid');
			$redirect_url=$this->input->post('redirect_url');
			//$item_type_array=$this->input->post('item_type');
            $indentData=array(
				"clinic_uid"=>$_SESSION['sessionLogInfo']['clinicId'],
				"location_uid_to"=>$this->input->post('store_uid'),
				"location_uid_from"=>7,
				"indent_date"=>$this->input->post('indent_date'),
				"priority"=>$this->input->post('priority'),
				"item_category"=>$this->input->post('category'),
				"remarks"=>$this->input->post('remarks'),
				"entry_by"=>$_SESSION['sessionLogInfo']['loggedUserId'],
				"entry_date_time"=>date("Y-m-d H:i:s")			
			);
			$this->Common_data_add_model->save_data($indentData,'inventory_indent');
			$indent_uid=$this->db->insert_id();
			
			for($i=0;$i<$no_indent_row;$i++)
			{
				$indentDetailsData=array(
					"indent_uid"=>$indent_uid,
					"item_uid"=>$item_uid_array[$i],
					"indent_quantity"=>$indent_quantity_array[$i],				
					"indent_unit_uid"=>$indent_unit_uid_array[$i],
					"item_type"=>1,
					"location_uid_from"=>7,
					"location_uid_to"=>$this->input->post('store_uid'),
					"clinic_uid"=>$_SESSION['sessionLogInfo']['clinicId'],
					"item_category"=>$this->input->post('category')
				);			
				$this->Common_data_add_model->save_data($indentDetailsData,'inventory_indent_details');
			}
			$this->session->set_flashdata('success', 'Data Saved...');	
				//log entry pass
					if($this->input->post('page_uid'))
						$page_uid=$this->input->post('page_uid');
					else
						$page_uid=1;
					$activity='Indent Save';
					log_entry($_SESSION['sessionLogInfo']['loggedUserId'],$page_uid,$activity_id=1,$activity);
			
			redirect(base_url().$redirect_url);
		}
	}


//--------stock block-----------------	
}
