<?php 
if (! defined('BASEPATH')) 
{
	exit('No direct script access allowed');
}
class Billing_data_fetch_model extends CI_Model
{
	public function fetch_items_dd()
	{
		$this->db->select('*');
		$this->db->from('master_item');
		$query = $this->db->get();
		$options = array();
		$options ["-1"] = "-- Select --";
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['item_name']."   [ Rs ".$row['rate']." ]";
		}
		return $options;	
	}
	public function fetch_all_doctors_name_dd()
	{
		$this->db->select('*');
		$this->db->from('employee');
		$this->db->where('employee_type',4);
		$query = $this->db->get();
		$options = array();
		$options ["-1"] = "-- Select --";
		foreach($query->result_array() as $row)
		{
		   $options [$row['full_name']] = $row['full_name'];
		}
		return $options;	
	}

	function fetch_item_rate($item_uid)
	{
		$this->db->select('*');
		$this->db->from('master_item');
		if($item_uid>0)
			$this->db->where('uid', $item_uid);
		$query=$this->db->get();
		return $query->row();		
	}
/*	
	function check_duplicate_invoice($current_invoice_no,$clinic_uid)
	{
		$this->db->select("count(*) as no_of_same_invoice");
		$this->db->from('billing_master');
		$this->db->where('clinic_uid',$clinic_uid);
		$this->db->where('invoice_no',$current_invoice_no);
		$query = $this->db->get();
		return $query->row();		
	}
*/
	function fetch_last_invoice_no($clinic_uid)
	{
		$this->db->select("max(invoice_no) as last_invoice_no");
		$this->db->from('billing_master');
		$this->db->where('clinic_uid',$clinic_uid);
		$query = $this->db->get();
		return $query->row();	
	}
/*	
	function check_duplicate_receipt($current_receipt_no,$clinic_uid)
	{
		$this->db->select("count(*) as no_of_same_receipt");
		$this->db->from('bill_receipt');
		$this->db->where('clinic_uid',$clinic_uid);
		$this->db->where('receipt_no',$current_receipt_no);
		$query = $this->db->get();
		return $query->row();		
	}
*/
	function fetch_last_receipt_no($clinic_uid)
	{
		$this->db->select("max(receipt_no) as last_receipt_no");
		$this->db->from('bill_receipt');
		$this->db->where('clinic_uid',$clinic_uid);
		$query = $this->db->get();
		return $query->row();	
	}
	public function fetch_patient_invoice_details($bill_no)
	{	
		$this->db->select("billmast_uid,bill_no,service_uid,item_id,mi.item_name,service_amount,discount_amount,gross_amount,bill_date,b.entry_date_time,cancel_flag");
		$this->db->from('billing b');		
		$this->db->join('master_item mi', 'mi.uid=b.item_id');		
		$this->db->where('billmast_uid',$bill_no);
		$query = $this->db->get();
		return $query->result();		
	}
	public function fetch_bill_master_details($bill_no)
	{
		$this->db->select("bm.uid,bm.entry_date_time,bill_date,bill_section,bm.sponsor_uid,patient_uid,treating_doctor,printAsDiet,full_name as 'patient_full_name',gender,age,dob,mobile,address1,address2,city,pin,gross_amount,discount_amount,net_amount,cancel_flag,bm.entry_by,bm.advance_receipt_id,bm.advance_amount,bm.invoice_no,bm.bill_prefix,bm.token_no");		
		$this->db->from('billing_master bm');
		$this->db->where('bm.uid',$bill_no);
		$query = $this->db->get();
		return $query->row();		
	}
	function fetch_bill_date_time($bill_no)
	{
		$this->db->select('entry_date_time');
		$this->db->from('billing_master');
		$this->db->where('uid',$bill_no);
		$query = $this->db->get();
		return $query->row();	
	}
	function fetch_employee_record($employee_uid)
	{
		$this->db->select('*');
		$this->db->from('employee');	
		$this->db->where('uid',$employee_uid);	
		$query = $this->db->get();
		return $query->row();	
	}
/*	public function fetch_service_id_by_bill_no($bill_no)
	{
		$this->db->select("distinct(service_uid)");
		$this->db->from('billing');
		$this->db->where('billmast_uid',$bill_no);
		$query = $this->db->get();
		return $query->result();		
	}*/
	public function fetch_patient_service_details($bill_no,$service_id)	
	{
	
		if($service_id==105 || $service_id==106 || $service_id==107  || $service_id==108 || $service_id==109 || $service_id==110 || $service_id==111 || $service_id==112 || $service_id==113 || $service_id==114 || $service_id==115)
		{
			$qry="SELECT t1.service_uid,item_id,service_amount,discount_amount,gross_amount,bill_date,c.item_name,t1.cancel_flag FROM  billing t1,item_services c where billmast_uid=$bill_no and c.uid=t1.item_id and t1.service_uid=$service_id";
		}			

		$query=$this->db->query($qry);
		$resultData=$query->result();			
		return $resultData;
	}
/*	function fetch_service_item_record($service_uid,$record_uid)
	{
		$this->db->select('*');
		$this->db->from('item_services');
		$this->db->where('service_uid',$service_uid);
		$this->db->where('uid',$record_uid);
		//$this->db->where('clinic_uid',$_SESSION['hims_employee_sessionLogInfo']['clinicId']);
		$query = $this->db->get();
		return $query->row();	
	}*/
	public function fetch_patient_payment_details($bill_no)
	{
		$this->db->select("receipt_prefix,uid,voucher_date,net_amount,cash_mode,card_mode,cheque_mode,bank_transfer_mode,advance_mode,upi_wallet_mode,receipt_no,source");
		$this->db->from('bill_receipt');
		$this->db->where('billmast_uid',$bill_no);
		$this->db->where_in('source',array(0,1));
		$query = $this->db->get();
		return $query->result();		
	}	
	public function fetch_patient_billing_master_details($bill_no)
	{
		$this->db->select("bm.uid, `bill_prefix`, `bill_date`, `patient_uid`, `gross_amount`, `discount_amount`, `net_amount`, `discount_reason`, `discount_approved_by`, `bill_section`, `treating_doctor`, bm.clinic_uid, bm.entry_by, bm.entry_date_time");
		$this->db->from('`billing_master bm');		
		$this->db->join('employee e', 'bm.entry_by=e.uid');		
		$this->db->where('bm.uid',$bill_no);
		$query = $this->db->get();
		return $query->row();		
	}
	public function fetch_clinic_by_id($clinic_uid)
	{
		$this->db->select('*');
		$this->db->from('master_clinic');
		$this->db->where('uid',$clinic_uid);
		$query = $this->db->get();
		return $query->row();	
	}
	function fetch_bill_list($search_parameter)	
	{
		$this->db->select("bm.uid, `bill_prefix`,`invoice_no`, `bill_date`, `bm`.`patient_uid`, `gross_amount`, `discount_amount`, `bm`.`net_amount`,bm.cancel_flag,full_name,mobile,gender");
		$this->db->from('`billing_master bm');		
		$this->db->where('bm.clinic_uid',$_SESSION['pab_sessionLogInfo']['clinicId']);
		$this->db->where('bm.bill_date>=',$search_parameter['from_date']);
		$this->db->where('bm.bill_date<=',$search_parameter['to_date']);
		if($search_parameter['patient_uid']>0)
			$this->db->where('bm.patient_uid',$search_parameter['patient_uid']);
		if($search_parameter['patient_name']!="")
			$this->db->like('bm.full_name',$search_parameter['patient_name']);
		if($search_parameter['bill_receipt_no']!="")
		{
			$invoice_receipt_no_prefix=substr($search_parameter['bill_receipt_no'], 0, strpos($search_parameter['bill_receipt_no'], '/'));
			$invoice_receipt_no_postfix=(int)(substr($search_parameter['bill_receipt_no'],strpos($search_parameter['bill_receipt_no'], '/')+1));
			$rcptString=substr($invoice_receipt_no_prefix,-4);
			$invoice_receipt_no_prefix=$invoice_receipt_no_prefix."/";
			if($rcptString=='OPRC')
			{
				$this->db->where('bm.uid=(select billmast_uid from bill_receipt where CONCAT(receipt_prefix,receipt_no)=\''.$invoice_receipt_no_prefix.$invoice_receipt_no_postfix.'\')' ,NULL, FALSE);
			}
			else
				$this->db->where('CONCAT(bm.bill_prefix,bm.invoice_no)',$invoice_receipt_no_prefix.$invoice_receipt_no_postfix);
		}			
		$query = $this->db->get();
		$result= $query->result();	
		return $result;
	}
	function fetch_scroll_list($search_parameter)
	{
		$this->db->select('entry_by,voucher_date,sum(net_amount) as sum_net,sum(cash_mode) as total_cash,sum(card_mode) as total_card,sum(cheque_mode) as total_cheque,sum(bank_transfer_mode) as total_bank_transfer,sum(advance_mode) as total_advance,sum(upi_wallet_mode) as total_upi_wallet');
		$this->db->from('bill_receipt');
		$this->db->where('entry_by',$_SESSION['pab_sessionLogInfo']['loggedUserId']);
		$this->db->where('clinic_uid',$_SESSION['pab_sessionLogInfo']['clinicId']);
		$this->db->where('cancel_flag','0');
		$this->db->where('voucher_date >=',date('Y-m-d',strtotime($search_parameter['from_date'])));
		$this->db->where('voucher_date <=',date('Y-m-d',strtotime($search_parameter['to_date'])));
		$this->db->group_by('voucher_date');
		$query = $this->db->get();
		return $query->result();		
	}
	
	
//----------------------------------------------------------------------------//	

}