<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Billing extends MX_Controller 
{

	public function __construct()
	{
		parent::__construct();
		
			if($_SESSION['pab_sessionLogInfo']['userLoggedin']!=true)
			{
			   redirect(base_url());
			}	

			$this->load->helper('utility');
			$this->load->model('Billing_data_fetch_model'); 
			$this->load->model('Billing_data_add_model'); 
			$this->load->model('Common/Common_data_fetch_model');
			$this->load->model('Common/Common_data_add_model');
			
	}

	function module()
	{
		$data=array();
		$this->load->view('module', $data);
	}
	function createBill()
	{
		$data=array();
		//get all items
		$data['all_items_dd']=$this->Billing_data_fetch_model->fetch_items_dd();
		$data['all_doctors_dd']=$this->Billing_data_fetch_model->fetch_all_doctors_name_dd();
		$data['bank_name_listDD']=$this->Common_data_fetch_model->fetch_misc_details_dropdown(104);//bank name list
		$data['wallet_name_listDD']=$this->Common_data_fetch_model->fetch_misc_details_dropdown(108);//bank name list
		
		$this->template->load('layout_billing', 'billing', $data);
	}
	function get_item_rate()
	{
		$response=$this->Billing_data_fetch_model->fetch_item_rate($this->input->post('item_uid'));
		if(!empty($response))
		{
			echo $response->rate;
		}
	
	}
	function saveBill()
	{
		
		$this->load->helper(array('form', 'url'));
		$this->load->library('form_validation');
		$this->form_validation->set_error_delimiters('<span style="color:red">', '</span>');
		$this->form_validation->set_rules('patient_name', 'Patient Name', 'required');
		$this->form_validation->set_rules('age', 'Age', 'required|alpha_numeric_spaces');
		$this->form_validation->set_rules('gender', 'Gender', 'required|numeric');
		$this->form_validation->set_rules('mobile', 'Mobile', 'required|numeric|exact_length[10]');
		$this->form_validation->set_rules('city', 'City', 'required|alpha');

		if($this->form_validation->run()!= FALSE)
		{		
			$item_array=$this->input->post('item_uid');			
			$row_gross_array=$this->input->post('gross');		
			$row_discount_array=$this->input->post('discount');		
			$row_net_array=$this->input->post('net');		
			
			$gross_amount=$this->input->post('gross_amount');
			$totItm_discount_amount=$this->input->post('totItm_discount_amount');
			$net_amount=$this->input->post('net_amount');
			
			$cash_amount=$this->input->post('cash_amount');
			$cheque_amount=$this->input->post('cheque_amount');
			$card_amount=$this->input->post('card_amount');
			$bank_transfer_amount=$this->input->post('bank_transfer_amount');
			$settlement_amount=$this->input->post('settlement_amount');
			$upi_wallet_amount=$this->input->post('upi_wallet_amount');

			$quantity_array=$this->input->post('quantity');
			$total_gross_amount=0;
			$total_net_amount=0;
			$total_paid_amount=0;
			$totalCalculatedItemDiscount=0;
			$special_discount_amount=0;
			$special_discount_reason="";
			$special_discount_approved_by=-1;
			$hd_date="";
			$agent=-1;
			foreach($row_gross_array as $key=>$value)
				$total_gross_amount+=$value;
			foreach($row_net_array as $key=>$value)
				$total_net_amount+=$value;
			
$total_paid_amount = 
    (float)$cash_amount + 
    (float)$cheque_amount + 
    (float)$card_amount + 
    (float)$bank_transfer_amount + 
    (float)$settlement_amount + 
    (float)$upi_wallet_amount;

				//$total_paid_amount=$cash_amount+$cheque_amount+$card_amount+$bank_transfer_amount+$settlement_amount+$upi_wallet_amount;
				
		
			//total item discount
			for($i=0;$i<count($row_discount_array);$i++)
			{
				$totalCalculatedItemDiscount+=$row_discount_array[$i];
			}
			
			$payble_amount=$total_net_amount;

			$hd_date="";

			$treating_doctor=$this->input->post('treating_doctor');
			
			//invoice no
			$selected_clinic_uid=$_SESSION['pab_sessionLogInfo']['clinicId'];//101;
			//get last invoice no against clinic uid
			$last_inv_response=$this->Billing_data_fetch_model->fetch_last_invoice_no($selected_clinic_uid);
			$current_invoice_no=($last_inv_response->last_invoice_no)+1;
			
			
			//financial year
			if((date('m')>=4) && (date('m')<=12))
			{
				$fy=date('Y').(date('Y')+1);
			}
			if((date('m')>=1) && (date('m')<=3))
			{
				$fy=(date('Y')-1).date('Y');
			}
		
			
			//save into billing master
				$data3=array(
					"bill_prefix"=>"OPBL/",
					"invoice_no"=>$current_invoice_no,
					"full_name"=>$this->input->post('patient_name'),
					"mobile"=>$this->input->post('mobile'),
					"city"=>$this->input->post('city'),
					"age"=>$this->input->post('age'),
					"gender"=>$this->input->post('gender'),
					"appointmentBooking_uid"=>0,
					"clinic_uid"=>$_SESSION['pab_sessionLogInfo']['clinicId'],
					"treating_doctor"=>$treating_doctor,
					"sponsor_uid"=>0,
					"bill_section"=>0,
					"entry_by"=>$_SESSION['pab_sessionLogInfo']['loggedUserId'],
					"gross_amount"=>$total_gross_amount,
					"discount_amount"=>$special_discount_amount+$totalCalculatedItemDiscount,
					"net_amount"=>$payble_amount-$special_discount_amount,
					"fy"=>$fy,
					"token_no"=>0,
					"entry_date_time"=>date('Y-m-d H:i:s'),
					"bill_date"=>date('Y-m-d')

				);
				if($this->input->post('printAsDietChart'))
					$data3['printAsDiet']=$this->input->post('printAsDietChart');
				else
					$data3['printAsDiet']=0;

				//insert record to billing table
				$billmast_uid=$this->Common_data_add_model->save_data($data3,'billing_master');

				$billno="OPBL/".$current_invoice_no;	
				//billing table insert start
				//count no of record in service array
				$item_array_len=count($item_array);
				$service_arr_net_amount=0;
				$inv_counter=0;
				for($i=0;$i<$item_array_len;$i++)
				{
					$service_date=date('Y-m-d');
					$agent_id=0;

					$data=array(
						"billmast_uid"=>$billmast_uid,
						"bill_no"=>$billno,
						"treating_doctor"=>$treating_doctor,
						"service_uid"=>0,
						"patient_uid"=>0,
						"clinic_uid"=>$_SESSION['pab_sessionLogInfo']['clinicId'],
						"agent_uid"=>$agent_id,
						"sponsor_uid"=>0,
						"entry_by"=>$_SESSION['pab_sessionLogInfo']['loggedUserId'],	
						"entry_date_time"=>date('Y-m-d H:i:s'),						
						"quantity"=>$quantity_array[$i],
						"service_amount"=>$row_gross_array[$i],
						"discount_amount"=>$row_discount_array[$i],
						"gross_amount"=>$row_net_array[$i],
						"urgent_flag"=>0,
						"fy"=>$fy,
						"date_of_service"=>date('Y-m-d'),
						"bill_date"=>date('Y-m-d')
					);
					
					$data += ["item_id" => base64_decode($item_array[$i])];
					
					//insert record to billing table
					$this->Common_data_add_model->save_data($data,'billing');
					$service_arr_net_amount+=$row_net_array[$i];
				}

				//get last invoice no against clinic uid
				$last_receipt_response=$this->Billing_data_fetch_model->fetch_last_receipt_no($selected_clinic_uid);
				$current_receipt_no=($last_receipt_response->last_receipt_no)+1;						
				
				$pdata=array(
						"receipt_prefix"=>"OPRC/",
						"billmast_uid"=>$billmast_uid,
						"bill_no"=>$billno,
						"receipt_no"=>$current_receipt_no,
						"payment_mode"=>0,
						"net_amount"=>$total_paid_amount,
						"cash_mode"=>$cash_amount,
						"card_mode"=>$card_amount,
						"cheque_mode"=>$cheque_amount,
						"bank_transfer_mode"=>$bank_transfer_amount,
						"advance_mode"=>$settlement_amount,
						"upi_wallet_mode"=>$upi_wallet_amount,
						
						"card_instrument_no"=>0,
						"instrument_date"=>date('Y-m-d'),
						"voucher_date"=>date('Y-m-d'),
						"voucher_time"=>date('H:i:s'),
						"patient_uid"=>0,
						"clinic_uid"=>$_SESSION['pab_sessionLogInfo']['clinicId'],
						"fy"=>$fy,
						"entry_by"=>$_SESSION['pab_sessionLogInfo']['loggedUserId'],
						"entry_date_time"=>date('Y-m-d H:i:s')					
					);			
				
				$rcpt_id=$this->Common_data_add_model->save_data($pdata,'bill_receipt');

				$payment_arr_net_amount=$total_paid_amount;
				
				//update payment flag
				$pflagData=array(
						"payment_flag"=>1				
					);
				$this->Common_data_add_model->update_data($pflagData,'billing','billmast_uid',$billmast_uid);	

				
				
				//set temp session to print bill
				$this->session->set_flashdata('temp_print_bill_no', $billmast_uid);

				redirect(base_url('billing/createBill'));
		}
		else
		{
			$data=array();
		//get all items
		$data['all_items_dd']=$this->Billing_data_fetch_model->fetch_items_dd();
		$data['all_doctors_dd']=$this->Billing_data_fetch_model->fetch_all_doctors_name_dd();
		$data['bank_name_listDD']=$this->Common_data_fetch_model->fetch_misc_details_dropdown(104);//bank name list
		$data['wallet_name_listDD']=$this->Common_data_fetch_model->fetch_misc_details_dropdown(108);//bank name list
		
		$this->template->load('layout_billing', 'billing', $data);

		}
	}
	function printBill($bill_no)
	{
		//get patient personal details and invoice no and invoice date
		$data['clinic_details']=$this->Billing_data_fetch_model->fetch_clinic_by_id($_SESSION['pab_sessionLogInfo']['clinicId']);

		//get patient personal details and invoice no and invoice date
		$data['patient_billing_master_data']=$this->Billing_data_fetch_model->fetch_bill_master_details($bill_no);

		$data['patient_personal_invoice_record']=$this->Billing_data_fetch_model->fetch_patient_invoice_details($bill_no);
		//print_r($data);die();
//echo $this->db->last_query();die();
		$data['bill_date_time_record']=$this->Billing_data_fetch_model->fetch_bill_date_time($bill_no);

		//get employee name
		$data['billEmployeeRecord']=$this->Billing_data_fetch_model->fetch_employee_record($data['patient_billing_master_data']->entry_by);

		//get patient payment details
		
		$payment_details=$this->Billing_data_fetch_model->fetch_patient_payment_details($bill_no);
		$pdata=[];
		foreach($payment_details as $record)
		{
			if($record->cash_mode>0)
			{			
				$pdata[]=(object)array(
					"mode"=>'Cash',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->cash_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}
			if($record->card_mode>0)
			{
				$pdata[]=(object)array(
					"mode"=>'Card',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->card_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}
			if($record->cheque_mode>0)
			{			
				$pdata[]=(object)array(
					"mode"=>'Cheque',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->cheque_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}			
			if($record->bank_transfer_mode>0)
			{			
				$pdata[]=(object)array(
					"mode"=>'NEFT/RTGS',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->bank_transfer_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}
			if($record->advance_mode>0)
			{			
				$pdata[]=(object)array(
					"mode"=>'Advance',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->advance_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}
			if($record->upi_wallet_mode>0)
			{
				$pdata[]=(object)array(
					"mode"=>'UPI/Wallet',
					"voucher_date"=>$record->voucher_date,
					"amount"=>$record->upi_wallet_mode,
					"receipt_no"=>$record->receipt_prefix.$record->receipt_no,
					"source"=>$record->source,
					"receipt_prefix"=>$record->receipt_prefix
				);
			}			
		}
		$data['patient_payment_details']=$pdata;
		//print_r($data['patient_payment_details']);die();
		
		$data['patient_billing_master_details']=$this->Billing_data_fetch_model->fetch_patient_billing_master_details($bill_no);

		$this->load->view('billing/print_bill',$data);
	
	}
	
	function fetch_sex_txt($sex_code)
	{
		switch($sex_code)
		{
			case 1:
				$sextxt="Female";
				break;
			case 2:
				$sextxt="Male";
				break;
			case 3:
				$sextxt="Transgender";
				break;	
		}
		return $sextxt;
	}
	function billingScroll()
	{
		$data=array();
		$this->template->load('layout_billing', 'billing_scroll', $data);
	}
	function closingStock()
	{
		$data=array();
		$this->template->load('layout_billing', 'closing_stock', $data);
	}	
	function billRegister()
	{
		$data=array();	
		$this->template->load('layout_billing', 'bill_list', $data);
	}
	function get_bill_list()
	{
		$search_parameter=$this->input->post();
		$bill_list_response=$this->Billing_data_fetch_model->fetch_bill_list($search_parameter);

		if(!empty($bill_list_response))
		{
			$sl=0;
			foreach($bill_list_response as $record)
			{
				if($record->cancel_flag==1)
				{
					echo '<tr style="background:#fd9088">';
				}
				else				
				{
				?>
				<tr>
				<?php
				}
				?>
					<td scope="row"><?=++$sl;?></td>
					<td scope="row"><?=$record->bill_prefix.$record->invoice_no?></td>
					<td scope="row"><?=date('d-m-Y',strtotime($record->bill_date))?></td>			
					<td scope="row"><?=$record->patient_uid?></td>			
					<td scope="row" width="30%" style="font-weight: bold"><?=$record->full_name?> | <?=(($record->gender==1)?'F':(($record->gender==2)?'M':'T'))?> | <?=$record->mobile?></td>
					<td scope="row"><?=$record->gross_amount?></td>
					<td scope="row"><?=$record->discount_amount?></td>
					<td scope="row"><?=$record->net_amount?></td>
					<td scope="row" width="15%">
					<?php
					if($record->cancel_flag==0)
					{					
					?>					
					<a class="btn from_button" href="<?=base_url()?>billing/printBill/<?=$record->uid?>" target="blank" title="Reprint">
						<i class="fa fa-print" aria-hidden="true"></i> Reprint
					</a>

					<?php
					}
					?>					
					</td>
				</tr>				
				<?php
				if($record->cancel_flag==0)
				{
					$total_gross_amount+=$record->gross_amount;
					$total_discount+=$record->discount_amount;
					$total_net+=$record->net_amount;
				}
			}
			?>
			<tr>
			<td  colspan="6"></td>
			<td ><strong><?php echo number_format((float)$total_gross_amount, 2, '.', '');?></strong></td>
			<td ><strong><?php echo number_format((float)$total_discount, 2, '.', '');?></strong></td>
			<td ><strong><?php echo number_format((float)$total_net, 2, '.', '');?></strong></td>
			</tr>			
			<?php
		}
		else
		{
			?>
			  <tr>
				<td colspan="9"><?="Data not available"?></td>
			  </tr>			
			<?php
		}
	}
	function get_scroll_list()
	{
		$search_parameter=$this->input->post();
		$response=$this->Billing_data_fetch_model->fetch_scroll_list($search_parameter);		
		if(!empty($response))
		{
			foreach($response as $record)
			{
				?>
              <tr>
				<td width="150"><?=get_employee_name($record->entry_by)?></td>
				<td width="150"><?=date('d-m-Y',strtotime($record->voucher_date))?></td>
                <td><?=$record->sum_net?></td>
                <td width=""><?=$record->total_cash?></td>
				<td width=""><?=$record->total_card?></td>
                <td width=""><?=$record->total_cheque?></td>
				<td width=""><?=$record->total_bank_transfer?></td>
				<td width=""><?=$record->total_upi_wallet?></td>
				<td width="">0</td>
              </tr>
				<?php
			}
				
		}
	}
	public function search_stock()
	{
		$searchTxt=$this->input->get('searchTxt');
		if($searchTxt!="")
		{
			// if($searchTxt=="%")
			// 	$searchTxt="";
			//$response = $this->Common_data_fetch_model->fetch_master_record($table='master_item',$select_fields_string='uid,item_name,rate',$search_filed='item_name',$search_field_value=$searchTxt,$is_like_search=1,$is_return_type_row=0);

			// $res = $this->db->query("SELECT master_item.item_name, COALESCE(SUM(purchase_details.quantity), 0) - SUM(billing.quantity) AS quantity FROM master_item LEFT JOIN purchase_details ON master_item.uid = purchase_details.item_uid INNER JOIN billing ON billing.item_id = master_item.uid WHERE master_item.item_name LIKE '%".$searchTxt."%' GROUP BY (master_item.item_name)");
			// $response = $res->result();
/* 			$response = $this->Common_data_fetch_model->fetch_master_record($table='master_item',$select_fields_string='uid,item_name,rate',$search_filed='item_name',$search_field_value=$searchTxt,$is_like_search=1,$is_return_type_row=0);
			$sl=0;
			foreach($response as $record)
			{
				$quantity = 0;
				$purchase_details = $this->Common_data_fetch_model->fetch_master_record($table='purchase_details',$select_fields_string='quantity',$search_filed='item_uid',$search_field_value=$record->uid,$is_like_search=0,$is_return_type_row=0);
				if(!empty($purchase_details))
				{
					foreach($purchase_details as $purchase_detail)
					{
						$quantity = $quantity + $purchase_detail->quantity;
					}
				}
				$sell_quantity = 0;
				$sell_details = $this->Common_data_fetch_model->fetch_master_record($table='billing',$select_fields_string='quantity,cancel_flag',$search_filed='item_id',$search_field_value=$record->uid,$is_like_search=0,$is_return_type_row=0);
				if(!empty($sell_details))
				{
					foreach($sell_details as $sell_detail)
					{
						if($sell_detail->cancel_flag==0)
							$sell_quantity = $sell_quantity + $sell_detail->quantity;
					}
				}
				$quantity = $quantity - $sell_quantity; */
				
			$response = $this->Common_data_fetch_model->fetch_master_record($table='master_item',$select_fields_string='uid,item_name,rate',$search_filed='item_name',$search_field_value=$searchTxt,$is_like_search=1,$is_return_type_row=0);
			$sl=0;
			foreach($response as $record)
			{
				$quantity = 0;
				//$purchase_details = $this->Common_data_fetch_model->fetch_master_record($table='purchase_details',$select_fields_string='quantity',$search_filed='item_uid',$search_field_value=$record->uid,$is_like_search=0,$is_return_type_row=0);
				$purchase_details = $this->Common_data_fetch_model->fetch_data_with_multiple_condition($table='purchase_details',$select_fields_string='quantity',$search_filed='item_uid',$search_field_value=$record->uid,$is_like_search=0,$is_return_type_row=0,array('item_uid'=>$record->uid,'clinic_uid'=>$_SESSION['pab_sessionLogInfo']['clinicId']),$where_condition=1);

				if(!empty($purchase_details))
				{
					foreach($purchase_details as $purchase_detail)
					{
						$quantity = $quantity + $purchase_detail->quantity;
					}
				}
				$sell_quantity = 0;
				//$sell_details = $this->Common_data_fetch_model->fetch_master_record($table='billing',$select_fields_string='quantity,cancel_flag',$search_filed='item_id',$search_field_value=$record->uid,$is_like_search=0,$is_return_type_row=0);
				$sell_details = $this->Common_data_fetch_model->fetch_data_with_multiple_condition($table='billing',$select_fields_string='quantity,cancel_flag',$search_filed='item_id',$search_field_value=$record->uid,$is_like_search=0,$is_return_type_row=0,array('item_id'=>$record->uid,'clinic_uid'=>$_SESSION['pab_sessionLogInfo']['clinicId']),$where_condition=1);
				if(!empty($sell_details))
				{
					foreach($sell_details as $sell_detail)
					{
						if($sell_detail->cancel_flag==0)
							$sell_quantity = $sell_quantity + $sell_detail->quantity;
					}
				}
				
				$issue_quantity = 0;
				$issue_details = $this->Common_data_fetch_model->fetch_data_with_multiple_condition($table='purchase_details',$select_fields_string='quantity',$search_filed='item_uid',$search_field_value=$record->uid,$is_like_search=0,$is_return_type_row=0,array('item_uid'=>$record->uid,'issue_from'=>$_SESSION['pab_sessionLogInfo']['clinicId'],'is_issue'=>1),$where_condition=1);
				if(!empty($issue_details))
				{
					foreach($issue_details as $issue_detail)
					{
						$issue_quantity = $issue_quantity + $issue_detail->quantity;
					}
				}				

				$quantity = ($quantity - $sell_quantity)-$issue_quantity;
				
			?>
			 <tr>
				<td><?=++$sl?></td>
				<td><?=$record->item_name?></td>
				<td><?=$quantity?></td>
			</tr>
			<?php
			}
		}
	}
	
}
