<?php 
if (! defined('BASEPATH')) 
{
	exit('No direct script access allowed');
}
class Admin_data_fetch_model extends CI_Model
{
	function fetch_bill_list($search_parameter)	
	{
		$this->db->select("bm.uid, `bill_prefix`,`invoice_no`, `bill_date`, `bm`.`patient_uid`, `gross_amount`, `discount_amount`, `bm`.`net_amount`,bm.cancel_flag,full_name,mobile,gender");
		$this->db->from('`billing_master bm');		
		$this->db->where('bm.clinic_uid',$_SESSION['pab_sessionLogInfo']['clinicId']);
		$this->db->where('bm.bill_date>=',$search_parameter['from_date']);
		$this->db->where('bm.bill_date<=',$search_parameter['to_date']);
		if($search_parameter['patient_uid']>0)
			$this->db->where('bm.patient_uid',$search_parameter['patient_uid']);
		if($search_parameter['patient_name']!="")
			$this->db->like('bm.full_name',$search_parameter['patient_name']);
		if($search_parameter['bill_receipt_no']!="")
		{
			$invoice_receipt_no_prefix=substr($search_parameter['bill_receipt_no'], 0, strpos($search_parameter['bill_receipt_no'], '/'));
			$invoice_receipt_no_postfix=(int)(substr($search_parameter['bill_receipt_no'],strpos($search_parameter['bill_receipt_no'], '/')+1));
			$rcptString=substr($invoice_receipt_no_prefix,-4);
			$invoice_receipt_no_prefix=$invoice_receipt_no_prefix."/";
			if($rcptString=='OPRC')
			{
				$this->db->where('bm.uid=(select billmast_uid from bill_receipt where CONCAT(receipt_prefix,receipt_no)=\''.$invoice_receipt_no_prefix.$invoice_receipt_no_postfix.'\')' ,NULL, FALSE);
			}
			else
				$this->db->where('CONCAT(bm.bill_prefix,bm.invoice_no)',$invoice_receipt_no_prefix.$invoice_receipt_no_postfix);
		}			
		$query = $this->db->get();
		$result= $query->result();	
		return $result;
	}
	public function fetch_all_employee_name_asDropDown($department_uid=-1,$employee_type=-1)
	{
		$this->db->select('*');
		$this->db->from('employee');
		if($department_uid!=-1)
			$this->db->where('department_uid',$department_uid);
		if($employee_type!=-1)
			$this->db->where('employee_type',$employee_type);
		
		$query = $this->db->get();
		$options = array();
		$options ["-1"] = "-- Select --";
		foreach($query->result_array() as $row)
		{
		   $options [$row['uid']] = $row['full_name'];
		}
		return $options;	
	}
	function fetch_scroll_list($search_parameter)
	{
		$this->db->select('entry_by,voucher_date,sum(net_amount) as sum_net,sum(cash_mode) as total_cash,sum(card_mode) as total_card,sum(cheque_mode) as total_cheque,sum(bank_transfer_mode) as total_bank_transfer,sum(advance_mode) as total_advance,sum(upi_wallet_mode) as total_upi_wallet');
		$this->db->from('bill_receipt');
		if($search_parameter['employee_uid']>0)
			$this->db->where('entry_by',$search_parameter['employee_uid']);
		$this->db->where('clinic_uid',$_SESSION['pab_sessionLogInfo']['clinicId']);
		$this->db->where('cancel_flag','0');
		$this->db->where('voucher_date >=',date('Y-m-d',strtotime($search_parameter['from_date'])));
		$this->db->where('voucher_date <=',date('Y-m-d',strtotime($search_parameter['to_date'])));
		$this->db->group_by('voucher_date');
		$query = $this->db->get();
		return $query->result();		
	}

}