<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends MX_Controller 
{

	public function __construct()
	{
		parent::__construct();
		
			if($_SESSION['pab_sessionLogInfo']['userLoggedin']!=true)
			{
			   redirect(base_url());
			}	

			$this->load->helper('utility');
			$this->load->model('Admin_data_fetch_model'); 
			$this->load->model('Admin_data_add_model'); 
			$this->load->model('Common/Common_data_fetch_model');
			$this->load->model('Common/Common_data_add_model');
			
	}
	function billList()
	{
		$data=array();
		$this->template->load('layout_admin', 'bill_list', $data);
	}
	function get_bill_list()
	{
		$search_parameter=$this->input->post();
		$bill_list_response=$this->Admin_data_fetch_model->fetch_bill_list($search_parameter);

		if(!empty($bill_list_response))
		{
			$sl=0;
			foreach($bill_list_response as $record)
			{
				if($record->cancel_flag==1)
				{
					echo '<tr style="background:#fd9088">';
				}
				else				
				{
				?>
				<tr>
				<?php
				}
				?>
					<td scope="row"><?=++$sl;?></td>
					<td scope="row"><?=$record->bill_prefix.$record->invoice_no?></td>
					<td scope="row"><?=date('d-m-Y',strtotime($record->bill_date))?></td>			
					<td scope="row"><?=$record->patient_uid?></td>			
					<td scope="row" width="30%" style="font-weight: bold"><?=$record->full_name?> | <?=(($record->gender==1)?'F':(($record->gender==2)?'M':'T'))?> | <?=$record->mobile?></td>
					<td scope="row"><?=$record->gross_amount?></td>
					<td scope="row"><?=$record->discount_amount?></td>
					<td scope="row"><?=$record->net_amount?></td>
					<td scope="row" width="15%">
					<?php
					if($record->cancel_flag==0)
					{					
					?>					
					<a class="btn from_button" href="<?=base_url()?>billing/printBill/<?=$record->uid?>" target="blank" title="Reprint">
						<i class="fa fa-print" aria-hidden="true"></i> Reprint
					</a>

					<a class="btn from_button" onclick="cancel_reason('<?=$record->uid?>')" href="javascript:void(0)" title="Bill cancel">
						<i class="fas fa-trash fa-fw" aria-hidden="true"></i> Cancel
					</a>
					<?php
					}
					?>					
					</td>
				</tr>				
				<?php
				if($record->cancel_flag==0)
				{
					$total_gross_amount+=$record->gross_amount;
					$total_discount+=$record->discount_amount;
					$total_net+=$record->net_amount;
				}
			}
			?>
			<tr>
			<td  colspan="6"></td>
			<td ><strong><?php echo number_format((float)$total_gross_amount, 2, '.', '');?></strong></td>
			<td ><strong><?php echo number_format((float)$total_discount, 2, '.', '');?></strong></td>
			<td ><strong><?php echo number_format((float)$total_net, 2, '.', '');?></strong></td>
			</tr>			
			<?php
		}
		else
		{
			?>
			  <tr>
				<td colspan="9"><?="Data not available"?></td>
			  </tr>			
			<?php
		}
	}
	function cancelBill()
	{	
		$cancel_date=date('Y-m-d');
		$postdata=$this->input->post();
				
		//update cancel flag
		$data=array(
				"cancel_flag"=>1,				
				"cancel_purpose"=>$data['reason'],				
				"cancel_date"=>$cancel_date,
				"cancel_by"=>$_SESSION['pab_sessionLogInfo']['loggedUserId']				
			);
		$this->Common_data_add_model->update_data($data,'billing_master','uid',$postdata['bid']);

		$data2=array(
				"cancel_flag"=>1
					
			);
		$this->Common_data_add_model->update_data($data2,$table='billing','billmast_uid',$postdata['bid']);
		$data3=array(
				"cancel_flag"=>1			
			);
		$this->Common_data_add_model->update_data($data3,'bill_receipt','billmast_uid',$postdata['bid']);		
		echo '1';
	}	
	function billingScroll()
	{
		$data=array();
		$data['all_employee_name_DD']=$this->Admin_data_fetch_model->fetch_all_employee_name_asDropDown($department_uid=-1,$employee_type=3);				
		$this->template->load('layout_admin', 'billing_scroll', $data);		
	}
	function get_scroll_list()
	{
		$search_parameter=$this->input->post();
		$response=$this->Admin_data_fetch_model->fetch_scroll_list($search_parameter);		
		if(!empty($response))
		{
			foreach($response as $record)
			{
				?>
              <tr>
				<td width="150"><?=get_employee_name($record->entry_by)?></td>
				<td width="150"><?=date('d-m-Y',strtotime($record->voucher_date))?></td>
                <td><?=$record->sum_net?></td>
                <td width=""><?=$record->total_cash?></td>
				<td width=""><?=$record->total_card?></td>
                <td width=""><?=$record->total_cheque?></td>
				<td width=""><?=$record->total_bank_transfer?></td>
				<td width=""><?=$record->total_upi_wallet?></td>
				<td width="">0</td>
              </tr>
				<?php
			}
				
		}
	}
	function manageStock()
	{
		$data=array();
		$this->template->load('layout_admin', 'manage_stock', $data);
	}
	function manageOutwardStock()
	{
		$data=array();
		$data['all_clinic']=$this->Common_data_fetch_model->fetch_clinic();		
		$this->template->load('layout_admin', 'manageOutwardStock', $data);
	}	
	function manageItem()
	{
		$data=array();
		$this->template->load('layout_admin', 'manage_item', $data);
	}
	function get_item_list()
	{
		$responseData=$this->Common_data_fetch_model->fetch_master_record($table='master_item',$select_fields_string='uid,item_name',$search_filed='item_name',$search_field_value="%",$is_like_search=1,$is_return_type_row=0);
		foreach($responseData as $record)
		{
		?>
		  <option value="<?= $record->uid ?>"> <?= $record->item_name?> </option>
		<?php
		}
	}
	function saveStock()
	{

		$this->load->library('form_validation');
		$this->form_validation->set_rules('item_uid', 'Item', 'required|numeric');		
		$this->form_validation->set_rules('quantity', 'Quantity', 'required|min_length[1]|numeric');
		$this->form_validation->set_rules('purchase_date', 'Purchase Date', 'required');
		
		if ( $this->form_validation->run() == FALSE)
		{  
			$data = array();
			$this->template->load('layout_admin', 'manage_stock', $data);
			
		} 
		else
		{
			$insertdata=$this->input->post();
			unset($insertdata['submit']);
			unset($insertdata['uid']);
			unset($insertdata['page_uid']);			
			$insertdata['clinic_uid']=$_SESSION['pab_sessionLogInfo']['clinicId'];			
			
			$this->Common_data_add_model->save_data($insertdata,'purchase_details ');
			$this->session->set_flashdata('success_msg', 'Data Saved...');	
			redirect(base_url()."admin/manageStock");
		}
		
	}
	function saveOutwardStock()
	{

		$this->load->library('form_validation');
		$this->form_validation->set_rules('item_uid', 'Item', 'required|numeric');		
		$this->form_validation->set_rules('quantity', 'Quantity', 'required|min_length[1]|numeric');
		$this->form_validation->set_rules('purchase_date', 'Purchase Date', 'required');
		
		if ( $this->form_validation->run() == FALSE)
		{  
			$data = array();
			$this->template->load('layout_admin', 'manage_stock', $data);
			
		} 
		else
		{
			$insertdata=$this->input->post();
			unset($insertdata['submit']);
			unset($insertdata['uid']);
			unset($insertdata['page_uid']);			
			unset($insertdata['issue_to_clinic_uid']);			
			$insertdata['purchase_uid']=0;			
			$insertdata['clinic_uid']=$this->input->post('issue_to_clinic_uid');			
			$insertdata['is_issue']=1;			
			$insertdata['issue_from']=$_SESSION['pab_sessionLogInfo']['clinicId'];			
			
			$this->Common_data_add_model->save_data($insertdata,'purchase_details ');

			$this->session->set_flashdata('success_msg', 'Data Saved...');	
			redirect(base_url()."admin/manageOutwardStock");
		}
		
	}

	function save_service_item()
	{
		$this->load->library('form_validation');
		
		$this->form_validation->set_rules('item_name', 'Name', 'required');
		$this->form_validation->set_rules('rate', 'Rate', 'required|numeric');

		if ($this->form_validation->run() == FALSE)
		{
			// echo $this->form_validation->error_string();
			$data = array();
			$this->template->load('layout_admin', 'manage_item', $data);
		}
		else
		{
			$postdata=$this->input->post();
			$uid=$postdata['uid'];
			unset($postdata['uid']);
			if($uid==0)
			{
				$this->Common_data_add_model->save_data($postdata,'master_item');
				$err = $this->db->error();
				$id=$this->db->insert_id();
				echo $id;
				print_r($err);
			}
			else
			{
				echo $this->Common_data_add_model->update_data($postdata,'master_item','uid',$uid);
			}
		}
	}
	function get_item_information()
	{
		$record_id=$this->input->get('uid');
		$responseData=$this->Common_data_fetch_model->fetch_master_record($table='master_item',$select_fields_string='uid,item_name,rate',$search_filed='uid',$search_field_value=$record_id,$is_like_search=0,$is_return_type_row=1);
		echo json_encode($responseData);
	}
	public function search_item()
	{
		$searchTxt=$this->input->get('searchTxt');
		if($searchTxt!="")
		{
			$response = $this->Common_data_fetch_model->fetch_master_record($table='master_item',$select_fields_string='uid,item_name,rate',$search_filed='item_name',$search_field_value=$searchTxt,$is_like_search=1,$is_return_type_row=0);
			$sl=0;
			foreach($response as $record)
			{
			?>
			<tr>
				<td><?=++$sl?></td>
				<td><?=$record->item_name?></td>
				<td><?=$record->rate?></td>
				<td>
					<a class="update-product" href="javascript:void(0)" onClick="edit_entry('<?=$record->uid?>')" title="Update" ><i class="fas fa-pencil-alt"></i></a> 
					<a  href="javascript:delete_record('')" title="Delete"><i class="fas fa-trash"></i></a>
				</td>
			</tr>
			<?php
			}
		}
	}
	public function search_stock()
	{
		$searchTxt=$this->input->get('searchTxt');
		if($searchTxt!="")
		{
			// if($searchTxt=="%")
			// 	$searchTxt="";
			//$response = $this->Common_data_fetch_model->fetch_master_record($table='master_item',$select_fields_string='uid,item_name,rate',$search_filed='item_name',$search_field_value=$searchTxt,$is_like_search=1,$is_return_type_row=0);

			// $res = $this->db->query("SELECT master_item.item_name, COALESCE(SUM(purchase_details.quantity), 0) - SUM(billing.quantity) AS quantity FROM master_item LEFT JOIN purchase_details ON master_item.uid = purchase_details.item_uid INNER JOIN billing ON billing.item_id = master_item.uid WHERE master_item.item_name LIKE '%".$searchTxt."%' GROUP BY (master_item.item_name)");
			// $response = $res->result();
			$response = $this->Common_data_fetch_model->fetch_master_record($table='master_item',$select_fields_string='uid,item_name,rate',$search_filed='item_name',$search_field_value=$searchTxt,$is_like_search=1,$is_return_type_row=0);
			$sl=0;
			foreach($response as $record)
			{
				$quantity = 0;
				//$purchase_details = $this->Common_data_fetch_model->fetch_master_record($table='purchase_details',$select_fields_string='quantity',$search_filed='item_uid',$search_field_value=$record->uid,$is_like_search=0,$is_return_type_row=0);
				$purchase_details = $this->Common_data_fetch_model->fetch_data_with_multiple_condition($table='purchase_details',$select_fields_string='quantity',$search_filed='item_uid',$search_field_value=$record->uid,$is_like_search=0,$is_return_type_row=0,array('item_uid'=>$record->uid,'clinic_uid'=>$_SESSION['pab_sessionLogInfo']['clinicId']),$where_condition=1);

				if(!empty($purchase_details))
				{
					foreach($purchase_details as $purchase_detail)
					{
						$quantity = $quantity + $purchase_detail->quantity;
					}
				}
				$sell_quantity = 0;
				//$sell_details = $this->Common_data_fetch_model->fetch_master_record($table='billing',$select_fields_string='quantity,cancel_flag',$search_filed='item_id',$search_field_value=$record->uid,$is_like_search=0,$is_return_type_row=0);
				$sell_details = $this->Common_data_fetch_model->fetch_data_with_multiple_condition($table='billing',$select_fields_string='quantity,cancel_flag',$search_filed='item_id',$search_field_value=$record->uid,$is_like_search=0,$is_return_type_row=0,array('item_id'=>$record->uid,'clinic_uid'=>$_SESSION['pab_sessionLogInfo']['clinicId']),$where_condition=1);
				if(!empty($sell_details))
				{
					foreach($sell_details as $sell_detail)
					{
						if($sell_detail->cancel_flag==0)
							$sell_quantity = $sell_quantity + $sell_detail->quantity;
					}
				}
				
				$issue_quantity = 0;
				$issue_details = $this->Common_data_fetch_model->fetch_data_with_multiple_condition($table='purchase_details',$select_fields_string='quantity',$search_filed='item_uid',$search_field_value=$record->uid,$is_like_search=0,$is_return_type_row=0,array('item_uid'=>$record->uid,'issue_from'=>$_SESSION['pab_sessionLogInfo']['clinicId'],'is_issue'=>1),$where_condition=1);
				if(!empty($issue_details))
				{
					foreach($issue_details as $issue_detail)
					{
						$issue_quantity = $issue_quantity + $issue_detail->quantity;
					}
				}				

				$quantity = ($quantity - $sell_quantity)-$issue_quantity;
			?>
			 <tr>
				<td><?=++$sl?></td>
				<td><?=$record->item_name?></td>
				<td><?=$quantity?></td>
			</tr>
			<?php
			}
		}
	}
	function printScroll()
	{
		$data=array();
		$this->load->view('print_scroll', $data);		
	}
}
